/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.commons.updater.factory;

import com.veraxsystems.commons.updater.conditions.AbstractCondition;
import com.veraxsystems.commons.updater.conditions.ColumnExistsCondition;
import com.veraxsystems.commons.updater.conditions.ConstraintExistsCondition;
import com.veraxsystems.commons.updater.conditions.DialectCondition;
import com.veraxsystems.commons.updater.conditions.IndexExistsCondition;
import com.veraxsystems.commons.updater.conditions.TableEmptyCondition;
import com.veraxsystems.commons.updater.conditions.TableExistsCondition;
import com.veraxsystems.commons.updater.conditions.TableNotEmptyCondition;
import com.veraxsystems.commons.updater.conditions.TableNotExistsCondition;
import com.veraxsystems.commons.updater.factory.AbstractTaskFactory;
import com.veraxsystems.commons.updater.tasks.AbstractTask;
import com.veraxsystems.commons.updater.tasks.CipherCustomPasswordsTask;
import com.veraxsystems.commons.updater.tasks.CipherStandardPasswordsTask;
import com.veraxsystems.commons.updater.tasks.CipherUserPasswordsTask;
import com.veraxsystems.commons.updater.tasks.DeleteFromTask;
import com.veraxsystems.commons.updater.tasks.DropCollumnTask;
import com.veraxsystems.commons.updater.tasks.InsertRowTask;
import com.veraxsystems.commons.updater.tasks.InstallReport;
import com.veraxsystems.commons.updater.tasks.PopulationSoftwareLicenseTask;
import com.veraxsystems.commons.updater.tasks.ResizeColumnTask;
import com.veraxsystems.commons.updater.tasks.RunScriptTask;
import com.veraxsystems.commons.updater.tasks.UpdateCollumnTask;

public class BasicTaskFactory
extends AbstractTaskFactory {
    @Override
    public AbstractTask createEmptyTask(String type) {
        if (type.equals("run.script")) {
            return new RunScriptTask();
        }
        if (type.equals("insert.row")) {
            return new InsertRowTask();
        }
        if (type.equals("delete.from")) {
            return new DeleteFromTask();
        }
        if (type.equals("drop.column")) {
            return new DropCollumnTask();
        }
        if (type.equals("resize.column")) {
            return new ResizeColumnTask();
        }
        if (type.equals("update.column")) {
            return new UpdateCollumnTask();
        }
        if (type.equals("cipher.passes")) {
            return new CipherUserPasswordsTask();
        }
        if (type.equals("cipher.custom")) {
            return new CipherCustomPasswordsTask();
        }
        if (type.equals("cipher.standard")) {
            return new CipherStandardPasswordsTask();
        }
        if (type.equals("install.report")) {
            return new InstallReport();
        }
        if (type.equals("population.license")) {
            return new PopulationSoftwareLicenseTask();
        }
        throw new IllegalArgumentException("Unsupported task type: '" + type + "'");
    }

    @Override
    public AbstractCondition createCondition(String type) {
        if (type.equals("dialect")) {
            return new DialectCondition();
        }
        if (type.equals("table.empty")) {
            return new TableEmptyCondition();
        }
        if (type.equals("table.not.empty")) {
            return new TableNotEmptyCondition();
        }
        if (type.equals("table.exists")) {
            return new TableExistsCondition();
        }
        if (type.equals("table.not.exists")) {
            return new TableNotExistsCondition();
        }
        if (type.equals("column.exists")) {
            return new ColumnExistsCondition();
        }
        if (type.equals("index.exists")) {
            return new IndexExistsCondition();
        }
        if (type.equals("constraint.exists")) {
            return new ConstraintExistsCondition();
        }
        throw new IllegalArgumentException("Condition handler for '" + type + "' not found");
    }
}

