/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.commons.updater.tasks;

import com.veraxsystems.commons.updater.tasks.AbstractTask;
import com.veraxsystems.commons.updater.tasks.UpdateCollumnTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.springframework.core.io.ClassPathResource;

public abstract class AbstractBlobSupportTask
extends AbstractTask {
    private static final Logger logger = Logger.getLogger(AbstractBlobSupportTask.class);
    protected ArrayList<String> colValues = null;

    protected abstract void executeBatch(Connection var1) throws SQLException;

    protected abstract String constructStatement();

    protected void executePrepared(Connection conn) throws SQLException {
        boolean containsBlob = false;
        for (String col : this.colValues) {
            if (!col.startsWith("{vx_updater_blob}") || !col.endsWith("{/vx_updater_blob}")) continue;
            containsBlob = true;
        }
        if (containsBlob || this instanceof UpdateCollumnTask) {
            PreparedStatement statement = conn.prepareStatement(this.constructStatement());
            int i = 1;
            for (String col : this.colValues) {
                if (col.startsWith("'") && col.endsWith("'")) {
                    statement.setString(i, col.substring(1, col.length() - 1));
                } else if (col.startsWith("{vx_updater_blob}") && col.endsWith("{/vx_updater_blob}")) {
                    File file = null;
                    FileInputStream is = null;
                    try {
                        if (col.startsWith("{vx_updater_blob}file://")) {
                            file = new File(col.substring("{vx_updater_blob}file://".length(), col.length() - "{/vx_updater_blob}".length()));
                            is = new FileInputStream(file);
                            statement.setBinaryStream(i, (InputStream)is, (int)file.length());
                        }
                        ClassPathResource cpr = new ClassPathResource(col.substring("{vx_updater_blob}".length(), col.length() - "{/vx_updater_blob}".length()));
                        is = new FileInputStream(cpr.getFile().getAbsolutePath());
                        statement.setBinaryStream(i, (InputStream)is, (int)cpr.getFile().length());
                    }
                    catch (IOException e) {
                        throw new SQLException("BLOB insertion error: file not found " + col, e);
                    }
                } else {
                    statement.setInt(i, new Integer(col));
                }
                ++i;
            }
            statement.executeUpdate();
        } else {
            this.executeBatch(conn);
        }
    }

    protected void prepareValues(String param) {
        this.colValues = new ArrayList();
        StringTokenizer st = new StringTokenizer(param, ", ");
        while (st.hasMoreTokens()) {
            this.colValues.add(st.nextToken());
        }
    }
}

