/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.commons.updater.tasks;

import com.veraxsystems.commons.updater.INode;
import com.veraxsystems.commons.updater.conditions.AbstractCondition;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractTask
implements Comparable<AbstractTask>,
INode {
    private Logger logger = Logger.getLogger(this.getClass());
    public Long id;
    public String type;
    public String author = "unknown";
    public String runatstartup = "0";
    public String runiffailed = "0";
    public String status = "new";
    public String application = "unspecified";
    public Map<String, String> properties = new HashMap<String, String>();
    public Collection<AbstractCondition> conditions = new ArrayList<AbstractCondition>();

    public void registerCondition(AbstractCondition condition) {
        this.conditions.add(condition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Connection conn) {
        this.logger.info("executing task id=" + this.id);
        try {
            if (this.validCondtions(conn).booleanValue()) {
                this.logger.info("conditions met");
                this.execute(conn);
                this.status = "executed ok";
            } else {
                this.logger.info("conditions not met");
                this.status = "executed ok: cond. not met";
            }
            this.logger.info("task id=" + this.id + " completed ok");
        }
        catch (Throwable t) {
            this.logger.error("task " + this.id + " failed", t);
            this.status = "failed";
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    this.logger.warn(e);
                }
            }
        }
    }

    protected abstract void execute(Connection var1) throws SQLException;

    public Boolean validCondtions(Connection conn) throws SQLException {
        for (AbstractCondition cond : this.conditions) {
            if (cond.execute(conn).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public void print() {
        this.logger.debug("id          = " + this.id);
        this.logger.debug("type        = " + this.type);
        this.logger.debug("application = " + this.application);
        this.logger.debug("runatstartup   = " + this.runatstartup);
        this.logger.debug("runiffailed   = " + this.runiffailed);
        this.logger.debug("properties : ");
        if (!this.properties.isEmpty()) {
            for (String key : this.properties.keySet()) {
                this.logger.debug(String.format("  name = %1$-20s value = " + this.properties.get(key), key));
            }
        } else {
            this.logger.debug("  empty");
        }
    }

    @Override
    public int compareTo(AbstractTask o) {
        Long tmp = 0L;
        if (this.id != null && o.id == null) {
            tmp = 1L;
        } else if (this.id != null && o.id != null) {
            tmp = this.id - o.id;
            if (tmp == 0L) {
                String thisApp = this.application == null ? "" : this.application;
                String oApp = o.application == null ? "" : o.application;
                tmp = thisApp.compareTo(oApp);
            }
        } else if (o.id != null) {
            tmp = -1L;
        }
        return tmp.intValue();
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setId(String id, File file) {
        if (id == null || id.isEmpty()) {
            throw new IllegalStateException("Missing id for taskNode in " + file);
        }
        this.id = Long.valueOf(id);
    }

    public void setAuthor(String author) {
        if (author != null && !author.isEmpty()) {
            this.author = author;
        }
    }

    public void setApplication(String application) {
        if (application != null) {
            this.application = application;
        }
    }

    public void setRunatstartup(String runatstartup) {
        if (runatstartup != null && !runatstartup.isEmpty()) {
            this.runatstartup = runatstartup;
        }
    }

    public void setRuniffailed(String runiffailed) {
        if (runiffailed != null && !runiffailed.isEmpty()) {
            this.runiffailed = runiffailed;
        }
    }

    @Override
    public String getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public void registerProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public boolean equals(Object o) {
        if (!(o instanceof AbstractTask)) {
            return false;
        }
        boolean result = true;
        AbstractTask task = (AbstractTask)o;
        result = result && (this.id == null && task.id == null || this.id != null && task.id != null && this.id.equals(task.id));
        result = result && (this.application == null && task.application == null || this.application != null && task.application != null && this.application.equals(task.application));
        return result;
    }

    protected List<String> getDialects(String prefix) {
        ArrayList<String> result = new ArrayList<String>();
        for (String key : this.properties.keySet()) {
            if (!key.startsWith(prefix)) continue;
            String dialect = key.substring(prefix.length());
            result.add(dialect);
        }
        return result;
    }

    public Boolean dialectMatch(Connection conn, String dialect) throws SQLException {
        String driverName = conn.getMetaData().getDriverName().toLowerCase();
        return driverName.contains(dialect);
    }
}

