/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.commons.updater.tasks;

import com.veraxsystems.commons.updater.tasks.AbstractTask;
import com.veraxsystems.commons.updater.utils.Base64;
import com.veraxsystems.sso.crypto.DesEncrypter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class CipherCustomPasswordsTask
extends AbstractTask {
    public static String USER_DES_KEY = "h4X0rRoX";
    private static Logger logger = Logger.getLogger(CipherCustomPasswordsTask.class);
    private static final int CLOB = 2005;
    private static final int VARCHAR = 12;

    @Override
    protected void execute(Connection conn) throws SQLException {
        String tableName = (String)this.properties.get("table.name");
        String columnName = (String)this.properties.get("column.name");
        String whereClause = (String)this.properties.get("where.clause");
        String pass = null;
        String passToEncrypt = null;
        Statement stmt = conn.createStatement(1005, 1008);
        ResultSet rs = stmt.executeQuery(String.format("SELECT %s FROM %s WHERE %s", columnName, tableName, whereClause));
        ResultSetMetaData rsmd = rs.getMetaData();
        conn.setAutoCommit(false);
        while (rs.next()) {
            if (rsmd.getColumnType(1) == 2005 && rs.getClob(1) != null) {
                Clob clobData = rs.getClob(1);
                passToEncrypt = clobData.getSubString(1L, (int)rs.getClob(1).length());
                if (passToEncrypt != null) {
                    pass = this.encrypt(passToEncrypt);
                    Writer writerClob = clobData.setCharacterStream(1L);
                    try {
                        writerClob.write(pass);
                        writerClob.flush();
                        writerClob.close();
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }
            } else if (rsmd.getColumnType(1) == 12 && rs.getString(1) != null && (passToEncrypt = rs.getString(1)) != null) {
                pass = this.encrypt(passToEncrypt);
                rs.updateString(1, pass);
            }
            if (passToEncrypt != null) {
                logger.debug("Pass before: " + passToEncrypt);
                logger.debug("Pass after: " + pass);
                rs.updateRow();
                continue;
            }
            logger.debug("No password to encrypt");
        }
        rs.close();
        stmt.close();
        conn.commit();
        conn.close();
    }

    protected String encrypt(String password) {
        try {
            DesEncrypter encrypter = new DesEncrypter(USER_DES_KEY);
            ByteArrayInputStream input = new ByteArrayInputStream(password.getBytes());
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            encrypter.encrypt((InputStream)input, (OutputStream)output);
            return Base64.encode(output.toByteArray());
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

