/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.commons.updater.tasks;

import com.veraxsystems.commons.updater.tasks.CipherCustomPasswordsTask;
import com.veraxsystems.commons.updater.utils.Base64;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class CipherStandardPasswordsTask
extends CipherCustomPasswordsTask {
    private Cipher encrypter;

    @Override
    protected void execute(Connection conn) throws SQLException {
        byte[] rawKey = Base64.decode((String)this.properties.get("cipher.key"));
        String cipher = (String)this.properties.get("cipher.algorithm");
        String keySpec = (String)this.properties.get("cipher.keySpec");
        SecretKeySpec key = new SecretKeySpec(rawKey, keySpec);
        try {
            this.encrypter = Cipher.getInstance(cipher);
            this.encrypter.init(1, (Key)key, new IvParameterSpec(rawKey));
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException(e);
        }
        super.execute(conn);
    }

    @Override
    protected String encrypt(String password) {
        try {
            return Base64.encode(this.encrypter.doFinal(password.getBytes("UTF-8")));
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException(e);
        }
        catch (BadPaddingException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

