/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.commons.updater.tasks;

import com.veraxsystems.commons.updater.tasks.AbstractBlobSupportTask;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class InsertRowTask
extends AbstractBlobSupportTask {
    private static Logger logger = Logger.getLogger(InsertRowTask.class);
    private String tableNameParam;
    private String namesParam;
    private String valuesParam;

    @Override
    protected void execute(Connection conn) throws SQLException {
        this.tableNameParam = (String)this.properties.get("table.name");
        this.namesParam = (String)this.properties.get("col.names");
        this.valuesParam = (String)this.properties.get("col.values");
        this.prepareValues(this.valuesParam);
        if (this.valuesParam.contains("{vx_updater_blob}")) {
            this.executePrepared(conn);
        } else {
            this.executeBatch(conn);
        }
    }

    @Override
    protected void executeBatch(Connection conn) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ").append(this.tableNameParam).append("(").append(this.namesParam);
        sql.append(") values (").append(this.valuesParam).append(")");
        Statement st = conn.createStatement();
        st.addBatch(sql.toString());
        logger.debug("sql: " + sql.toString());
        st.executeBatch();
    }

    @Override
    protected String constructStatement() {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ").append(this.tableNameParam).append("(").append(this.namesParam);
        sql.append(") values (");
        for (int i = 0; i < this.colValues.size(); ++i) {
            sql.append("?");
            if (this.colValues.size() > i + 1) {
                sql.append(",");
                continue;
            }
            sql.append(")");
        }
        return sql.toString();
    }
}

