/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.commons.updater.tasks;

import com.veraxsystems.commons.updater.reports.DataSourceInstaller;
import com.veraxsystems.commons.updater.tasks.AbstractTask;
import com.veraxsystems.configuration.VxPropertyConfigurer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class InstallDataSourceTask
extends AbstractTask {
    private static final Logger logger = Logger.getLogger(InstallDataSourceTask.class);
    private static final Pattern placeholderPatter = Pattern.compile("^\\$\\{(.+?)\\}$");
    private static final String DATA_SOURCE_NAME = "dataSource.name";
    private static final String JDBC_DRIVER_CLASS = "jdbcDriverClass";
    private static final String URL = "url";
    private static final String USER = "user";
    private static final String PASSWORD = "password";
    private static final String DIALECT = "dialect";
    private DataSourceInstaller remoteAcConnectionRegistryService;
    private VxPropertyConfigurer propertyConfigurer;

    public InstallDataSourceTask(DataSourceInstaller remoteAcConnectionRegistryService, VxPropertyConfigurer propertyConfigurer) {
        this.remoteAcConnectionRegistryService = remoteAcConnectionRegistryService;
        this.propertyConfigurer = propertyConfigurer;
    }

    @Override
    protected void execute(Connection conn) throws SQLException {
        if (this.remoteAcConnectionRegistryService == null) {
            throw new RuntimeException("Remote AC connection registry service is not initialized.");
        }
        String dataSourceName = (String)this.properties.get(DATA_SOURCE_NAME);
        Properties props = new Properties();
        props.put(JDBC_DRIVER_CLASS, this.getParameterValue(JDBC_DRIVER_CLASS));
        props.put(URL, this.getParameterValue(URL));
        props.put(USER, this.getParameterValue(USER));
        props.put(PASSWORD, this.getParameterValue(PASSWORD));
        props.put(DIALECT, this.getParameterValue(DIALECT));
        logger.debug("Installing data source: " + dataSourceName);
        this.remoteAcConnectionRegistryService.add(dataSourceName, props);
    }

    private String getParameterValue(String propertyName) {
        String result = null;
        String propertyKey = (String)this.properties.get(propertyName);
        if (propertyKey == null || propertyKey.isEmpty()) {
            throw new RuntimeException(String.format("Parameter %s is missing.", propertyName));
        }
        Matcher matcher = placeholderPatter.matcher(propertyKey);
        String placeholder = null;
        placeholder = matcher.matches() ? matcher.group(1) : propertyKey;
        result = this.propertyConfigurer.getProperty(placeholder);
        if (result == null || result.isEmpty()) {
            result = propertyKey;
        }
        return result;
    }
}

