/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.commons.updater.tasks;

import com.veraxsystems.commons.updater.tasks.AbstractTask;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.tools.ant.filters.StringInputStream;
import org.springframework.core.io.ClassPathResource;

public class InstallReport
extends AbstractTask {
    private static Logger logger = Logger.getLogger(InstallReport.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute(Connection conn) throws SQLException {
        Long reportId = Long.parseLong((String)this.properties.get("report.id"));
        String reportName = (String)this.properties.get("report.name");
        String reportDesc = (String)this.properties.get("report.desc");
        String reportFileName = (String)this.properties.get("report.file");
        String hibernateProperties = (String)this.properties.get("hibernateProperties");
        String pass = null;
        String user = null;
        String driver = null;
        String connStr = null;
        Properties props = new Properties();
        try {
            props.load((InputStream)new StringInputStream(hibernateProperties));
            for (Object key : props.keySet()) {
                if ("hibernate.connection.username".equals(key.toString())) {
                    user = props.get(key).toString();
                    continue;
                }
                if ("hibernate.connection.password".equals(key.toString())) {
                    pass = props.get(key).toString();
                    continue;
                }
                if ("hibernate.connection.driver_class".equals(key.toString())) {
                    driver = props.get(key).toString();
                    continue;
                }
                if (!"hibernate.connection.url".equals(key.toString())) continue;
                connStr = props.get(key).toString();
            }
        }
        catch (IOException e1) {
            logger.warn("Could not load connection properties");
        }
        if (!reportFileName.equals("")) {
            try {
                Integer has_params = 0;
                for (Map.Entry me : this.properties.entrySet()) {
                    if (!me.getKey().toString().startsWith("parameter.")) continue;
                    has_params = 1;
                }
                PreparedStatement psReport = conn.prepareStatement("INSERT INTO bss_report_def (id, conn_db_pass, conn_db_port, conn_db_type, conn_db_user, conn_string, description, has_params, has_schedule, name, outputformat, retention_days, schedule, xcontent) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                ClassPathResource resourceFile = new ClassPathResource(reportFileName);
                File file = null;
                InputStream stream = null;
                try {
                    file = resourceFile.getFile();
                    stream = resourceFile.getInputStream();
                    psReport.setLong(1, reportId);
                    psReport.setString(2, pass);
                    psReport.setString(3, null);
                    psReport.setString(4, driver);
                    psReport.setString(5, user);
                    psReport.setString(6, connStr);
                    psReport.setString(7, reportDesc);
                    psReport.setInt(8, has_params);
                    psReport.setInt(9, 0);
                    psReport.setString(10, reportName);
                    psReport.setInt(11, 0);
                    psReport.setInt(12, 0);
                    psReport.setString(13, null);
                    psReport.setAsciiStream(14, stream, (int)file.length());
                    psReport.executeUpdate();
                }
                finally {
                    psReport.close();
                }
                PreparedStatement psParams = conn.prepareStatement("INSERT INTO bss_report_def_params (param_id, param_name, param_type, param_value, report_fk) VALUES (hibernate_sequence.nextval, ?, ?, ?, ?)");
                try {
                    for (Map.Entry me : this.properties.entrySet()) {
                        Date date;
                        if (!me.getKey().toString().startsWith("parameter.")) continue;
                        has_params = 1;
                        String[] data = me.getValue().toString().split(";");
                        String name = me.getKey().toString().substring(10);
                        String type = "";
                        String value = "";
                        if (data.length > 0) {
                            type = data[0];
                        }
                        if (data.length > 1) {
                            value = data[1];
                        }
                        if (name.toUpperCase().indexOf("TO_DATE") >= 0 || name.toUpperCase().indexOf("TO_TIME") >= 0) {
                            date = new Date();
                            Timestamp timestamp = new Timestamp(date.getTime());
                            Long time = timestamp.getTime();
                            value = time.toString();
                        } else if (name.toUpperCase().indexOf("FROM_DATE") >= 0 || name.toUpperCase().indexOf("FROM_TIME") >= 0) {
                            date = new Date();
                            Integer weekMiliseconds = 86400000;
                            Timestamp timestamp = new Timestamp(date.getTime() - (long)weekMiliseconds.intValue());
                            Long time = timestamp.getTime();
                            value = time.toString();
                        } else if (name.toUpperCase().indexOf("SUBREPORT_DIR") >= 0) {
                            value = resourceFile.getFile().getParent();
                        }
                        psParams.setString(1, name);
                        psParams.setString(2, type);
                        psParams.setString(3, value);
                        psParams.setLong(4, reportId);
                        psParams.executeUpdate();
                    }
                }
                finally {
                    psParams.close();
                }
            }
            catch (Throwable e) {
                logger.warn("Could not install report: " + reportFileName);
                logger.debug("Could not install report: " + reportFileName + ", " + e.getMessage());
            }
        }
    }
}

