/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.commons.updater.tasks;

import com.veraxsystems.commons.updater.reports.ReportDefinitionInstaller;
import com.veraxsystems.commons.updater.reports.ReportDescriptor;
import com.veraxsystems.commons.updater.tasks.AbstractTask;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class InstallReportDefinitionTask
extends AbstractTask {
    private static final Logger logger = Logger.getLogger(InstallReportDefinitionTask.class);
    private static final String REPORT_NAME = "reportName";
    private static final String REPORT_DESCRIPTION = "reportDescription";
    private static final String REPORT_TEMPLATE_NAME = "reportTemplateName";
    private static final String DATA_SOURCE = "dataSource";
    private static final String REPORT_PARAMETER_PREFIX = "param_";
    private static final String REPORT_PARAMETER_TYPE_PREFIX = "paramType_";
    private ReportDefinitionInstaller remoteReportTemplateService;

    public InstallReportDefinitionTask(ReportDefinitionInstaller remoteReportTemplateService) {
        this.remoteReportTemplateService = remoteReportTemplateService;
    }

    @Override
    protected void execute(Connection conn) throws SQLException {
        if (this.remoteReportTemplateService == null) {
            throw new RuntimeException("Remote report service is not initialized.");
        }
        ReportDescriptor reportDescriptor = new ReportDescriptor();
        reportDescriptor.setTemplateName((String)this.properties.get(REPORT_TEMPLATE_NAME));
        if (this.properties.get(DATA_SOURCE) != null && !((String)this.properties.get(DATA_SOURCE)).isEmpty()) {
            reportDescriptor.setDataSourceName((String)this.properties.get(DATA_SOURCE));
        }
        reportDescriptor.setName((String)this.properties.get(REPORT_NAME));
        reportDescriptor.setDescription((String)this.properties.get(REPORT_DESCRIPTION));
        for (String key : this.properties.keySet()) {
            if (!key.startsWith(REPORT_PARAMETER_PREFIX)) continue;
            String parameterName = key.substring(REPORT_PARAMETER_PREFIX.length());
            String parameterValue = (String)this.properties.get(key);
            String parameterType = (String)this.properties.get(REPORT_PARAMETER_TYPE_PREFIX + parameterName);
            reportDescriptor.addReportParameter(parameterName, parameterType, parameterValue);
        }
        logger.debug("Installing report definition: " + reportDescriptor.getName());
        this.remoteReportTemplateService.populateReportDefinition(reportDescriptor);
    }
}

