/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.commons.updater.tasks;

import com.veraxsystems.commons.updater.reports.ReportTemplateInstaller;
import com.veraxsystems.commons.updater.tasks.AbstractTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.core.io.ClassPathResource;

public class InstallReportTemplateTask
extends AbstractTask {
    private static final Logger logger = Logger.getLogger(InstallReportTemplateTask.class);
    private static final String REPORT_TEMPLATE = "reportTemplate.path";
    private ReportTemplateInstaller remoteReportTemplateService;

    public InstallReportTemplateTask(ReportTemplateInstaller remoteReportTemplateService) {
        this.remoteReportTemplateService = remoteReportTemplateService;
    }

    @Override
    protected void execute(Connection conn) throws SQLException {
        ClassPathResource script = null;
        List<String> dialects = this.getDialects("reportTemplate.path.");
        for (String dialect : dialects) {
            if (!this.dialectMatch(conn, dialect).booleanValue()) continue;
            String scriptName = (String)this.properties.get("reportTemplate.path." + dialect);
            script = new ClassPathResource(scriptName);
            logger.debug("task " + this.application + "." + this.id + " is using script " + scriptName + " (dialect: " + dialect + ").");
            break;
        }
        if (script == null) {
            script = new ClassPathResource((String)this.properties.get(REPORT_TEMPLATE));
        }
        if (!script.exists()) {
            throw new RuntimeException(String.format("Report templates file not found: %s", script.getPath()));
        }
        try {
            logger.debug("Installing report template package: " + script.getPath());
            this.remoteReportTemplateService.addTemplateFromPackage(this.getBytesFromFile(script.getFile()));
        }
        catch (IOException e) {
            logger.error(e, e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytesFromFile(File file) throws IOException {
        FileInputStream is = null;
        byte[] bytes = null;
        try {
            int offset;
            is = new FileInputStream(file);
            long length = file.length();
            if (length > Integer.MAX_VALUE) {
                throw new IOException("File is too large.");
            }
            bytes = new byte[(int)length];
            int numRead = 0;
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        return bytes;
    }
}

