/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.commons.updater.tasks;

import com.veraxsystems.commons.updater.tasks.AbstractTask;
import com.veraxsystems.commons.updater.utils.OssBssLicense;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public class PopulationSoftwareLicenseTask
extends AbstractTask {
    private static final Logger logger = Logger.getLogger(PopulationSoftwareLicenseTask.class);
    private String tableName = null;
    private String licenseB64 = null;
    private String sequence = null;

    @Override
    protected void execute(Connection conn) {
        try {
            this.sequence = (String)this.properties.get("sequence");
            this.tableName = (String)this.properties.get("table.name");
            this.licenseB64 = (String)this.properties.get("license.key");
            if (this.tableName != null && this.licenseB64 != null) {
                String[] _licenseB64 = this.licenseB64.split(";");
                for (int i = 0; i < _licenseB64.length; ++i) {
                    this.insertLicense(conn, _licenseB64[i], this.sequence);
                }
            } else {
                throw new Exception("Not given in full for all properties");
            }
            conn.close();
        }
        catch (Throwable t) {
            logger.error(t, t);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void insertLicense(Connection conn, String licenseB64, String sequence) {
        try {
            String query = null;
            byte[] decodedBytes = Base64.decodeBase64(licenseB64.getBytes());
            String license = new String(decodedBytes);
            Properties inputProperties = new Properties();
            inputProperties.load(new StringReader(license));
            String feature = inputProperties.getProperty("feature");
            String count = inputProperties.getProperty("count");
            String guid = inputProperties.getProperty("guid");
            String expiry_date = inputProperties.getProperty("expiry_date");
            String encrypted = inputProperties.getProperty("signature");
            String description = inputProperties.getProperty("description");
            String hardware_id = "not applicable";
            String driverName = conn.getMetaData().getDriverName().toLowerCase();
            if (driverName != null && driverName.contains("oracle")) {
                if (sequence == null) throw new Exception("Please specify sequence nane parameter");
                query = String.format("Insert into %s (ID,COUNT,DESCRIPTION,ENCRYPTED,EXPIRYDATE,FEATURE,FILECONTENT,IMPORTEDON,LICENSESTATUS,GUID,HARDWAREID) values (" + sequence + ",?,?,?,?,?,?,?,?,?,?)", this.tableName);
            } else if (driverName.contains("mysql")) {
                query = String.format("Insert into %s (COUNT,DESCRIPTION,ENCRYPTED,EXPIRYDATE,FEATURE,FILECONTENT,IMPORTEDON,LICENSESTATUS,GUID,HARDWAREID) values (?,?,?,?,?,?,?,?,?,?)", this.tableName);
            } else {
                if (!driverName.contains("microsoft sql server")) throw new Exception("Dialect not supported by the license task");
                query = String.format("Insert into %s (COUNT,DESCRIPTION,ENCRYPTED,EXPIRYDATE,FEATURE,FILECONTENT,IMPORTEDON,LICENSESTATUS,GUID,HARDWAREID) values (?,?,?,?,?,?,?,?,?,?)", this.tableName);
            }
            if (query == null) {
                throw new Exception("Build insert licence query failed");
            }
            PreparedStatement preSt = conn.prepareStatement(query);
            preSt.setInt(1, Integer.valueOf(count));
            preSt.setString(2, description);
            preSt.setString(3, encrypted);
            preSt.setTimestamp(4, new Timestamp(OssBssLicense.getDateFormat().parse(expiry_date).getTime()));
            preSt.setString(5, feature);
            preSt.setString(6, "");
            preSt.setTimestamp(7, new Timestamp(new Date().getTime()));
            preSt.setInt(8, 1);
            preSt.setString(9, guid);
            preSt.setString(10, hardware_id);
            preSt.executeUpdate();
            return;
        }
        catch (Throwable t) {
            logger.error(t, t);
        }
    }
}

