/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.commons.updater.tasks;

import com.veraxsystems.commons.updater.conditions.DialectCondition;
import com.veraxsystems.commons.updater.tasks.AbstractTask;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class ResizeColumnTask
extends AbstractTask {
    private static Logger logger = Logger.getLogger(ResizeColumnTask.class);

    @Override
    protected void execute(Connection conn) throws SQLException {
        DatabaseMetaData dmd = conn.getMetaData();
        String driver = dmd.getDriverName().toLowerCase();
        if (driver.contains("sql server")) {
            StringBuilder sql = new StringBuilder();
            sql.append("alter table ");
            sql.append((String)this.properties.get("table.name"));
            sql.append(" alter column ");
            sql.append((String)this.properties.get("column.name"));
            sql.append(" VARCHAR(");
            sql.append((String)this.properties.get("new.size"));
            sql.append(")");
            Statement st = conn.createStatement();
            st.addBatch(sql.toString());
            logger.info("sql: " + sql.toString());
            st.executeBatch();
        } else {
            StringBuilder sql = new StringBuilder();
            sql.append("alter table ");
            sql.append((String)this.properties.get("table.name"));
            sql.append(" modify ");
            sql.append((String)this.properties.get("column.name"));
            sql.append(" VARCHAR(");
            sql.append((String)this.properties.get("new.size"));
            DialectCondition dc = new DialectCondition();
            dc.registerProperty("value", "oracle");
            if (dc.execute(conn).booleanValue()) {
                sql.append(" CHAR");
            }
            sql.append(")");
            Statement st = conn.createStatement();
            st.addBatch(sql.toString());
            logger.info("sql: " + sql.toString());
            st.executeBatch();
        }
    }
}

