/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.commons.updater.tasks;

import com.veraxsystems.commons.updater.BaseFilePopulator;
import com.veraxsystems.commons.updater.tasks.AbstractTask;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.core.io.ClassPathResource;

public class RunScriptTask
extends AbstractTask {
    private static Logger logger = Logger.getLogger(RunScriptTask.class);

    @Override
    protected void execute(Connection conn) throws SQLException {
        ClassPathResource script = null;
        List<String> dialects = this.getDialects();
        for (String dialect : dialects) {
            if (!this.dialectMatch(conn, dialect).booleanValue()) continue;
            String scriptName = (String)this.properties.get("script.path." + dialect);
            script = new ClassPathResource(scriptName);
            logger.debug("task " + this.application + "." + this.id + " is using script " + scriptName + " (dialect: " + dialect + ").");
            break;
        }
        if (script == null) {
            script = new ClassPathResource((String)this.properties.get("script.path"));
        }
        BaseFilePopulator populator = new BaseFilePopulator();
        try {
            logger.info("running script: " + script.getFile().getAbsolutePath());
            populator.populateFromFile(script, conn);
            logger.info("script: " + script.getFile().getAbsolutePath() + " finished");
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    protected List<String> getDialects() {
        ArrayList<String> result = new ArrayList<String>();
        for (String key : this.properties.keySet()) {
            if (!key.startsWith("script.path.")) continue;
            String dialect = key.substring("script.path.".length());
            result.add(dialect);
        }
        return result;
    }
}

