/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.commons.updater.tasks;

import com.veraxsystems.commons.updater.tasks.AbstractBlobSupportTask;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class UpdateCollumnTask
extends AbstractBlobSupportTask {
    private static Logger logger = Logger.getLogger(UpdateCollumnTask.class);
    private String tableNameParam;
    private String colNameParam;
    private String newValueParam;
    private String whereClauseParam;

    @Override
    protected void execute(Connection conn) throws SQLException {
        this.tableNameParam = (String)this.properties.get("table.name");
        this.colNameParam = (String)this.properties.get("column.name");
        this.newValueParam = (String)this.properties.get("new.value");
        this.whereClauseParam = (String)this.properties.get("where.clause");
        this.prepareValues(this.newValueParam);
        if (this.newValueParam.contains("{vx_updater_blob}") || this.newValueParam.contains(",")) {
            this.executePrepared(conn);
        } else {
            this.executeBatch(conn);
        }
    }

    @Override
    protected void executeBatch(Connection conn) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("update ").append(this.tableNameParam).append(" set ");
        sql.append(this.colNameParam).append(" = '").append(this.newValueParam).append("' ");
        if (this.whereClauseParam != null && !this.whereClauseParam.isEmpty()) {
            sql.append(" where ").append(this.whereClauseParam);
        }
        Statement st = conn.createStatement();
        st.addBatch(sql.toString());
        logger.debug("executing " + sql.toString());
        st.executeBatch();
    }

    @Override
    protected String constructStatement() {
        ArrayList<String> colNames = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(this.colNameParam, ", ");
        while (st.hasMoreTokens()) {
            colNames.add(st.nextToken());
        }
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(this.tableNameParam).append(" set ");
        for (int i = 0; i < this.colValues.size(); ++i) {
            sql.append((String)colNames.get(i)).append(" = ").append("?");
            if (this.colValues.size() > i + 1) {
                sql.append(", ");
                continue;
            }
            if (this.whereClauseParam == null || this.whereClauseParam.isEmpty()) continue;
            sql.append(" where ").append(this.whereClauseParam);
        }
        return sql.toString();
    }
}

