/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.licensing.signer;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;

public class Signer {
    private static String privateKeyFile;
    private static String publicKeyFile;
    private static String signatureFile;
    private static Mode mode;
    private static String feature;
    private static long count;
    private static Date date;

    public static void main(String[] args) throws Throwable {
        Signer.execute(args);
    }

    public static boolean execute(String[] args) throws Throwable {
        mode = Mode.UNKNOWN;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.compareTo("-genkey") == 0) {
                System.out.println("Parsed genkey mode.");
                mode = Mode.GENKEY;
                continue;
            }
            if (arg.compareTo("-sign") == 0) {
                System.out.println("Parsed sign mode.");
                mode = Mode.SIGN;
                continue;
            }
            if (arg.compareTo("-verify") == 0) {
                System.out.println("Parsed verify mode.");
                mode = Mode.VERIFY;
                continue;
            }
            if (arg.compareTo("-priv") == 0) {
                privateKeyFile = args[++i];
                System.out.printf("Parsed private key file name (%s).\n", privateKeyFile);
                continue;
            }
            if (arg.compareTo("-pub") == 0) {
                publicKeyFile = args[++i];
                System.out.printf("Parsed public key file name (%s).\n", publicKeyFile);
                continue;
            }
            if (arg.compareTo("-out") == 0 || arg.compareTo("-in") == 0) {
                signatureFile = args[++i];
                System.out.printf("Parsed signature file name (%s).\n", signatureFile);
                continue;
            }
            if (arg.compareTo("-f") == 0) {
                feature = args[++i];
                System.out.printf("Parsed feature parameter (%s).\n", feature);
                continue;
            }
            if (arg.compareTo("-c") == 0) {
                count = Long.parseLong(args[++i]);
                System.out.printf("Parsed count parameter (%s).\n", count);
                continue;
            }
            if (arg.compareTo("-d") == 0) {
                date = new SimpleDateFormat("yyyy-MM-dd").parse(args[++i]);
                System.out.printf("Parsed date parameter (%s).\n", new SimpleDateFormat("yyyy-MM-dd").format(date));
                continue;
            }
            System.err.printf("Unhandled arg: %s\n", arg);
            Signer.usage();
            return true;
        }
        switch (mode) {
            case UNKNOWN: {
                Signer.usage();
                return true;
            }
            case GENKEY: {
                Signer.generateKeys();
                return true;
            }
            case SIGN: {
                Signer.generateSignature(privateKeyFile, feature, (Long)count, date);
                return true;
            }
            case VERIFY: {
                return Signer.verify();
            }
        }
        return true;
    }

    private static void usage() {
        System.out.println("usage: program -genkey -priv private_key_file -pub pubublic_key_file");
        System.out.println("       program -sign -priv private_key_file -f feature");
        System.out.println("               -c count -d date [ -out signature_file ]");
        System.out.println("       program -verify -pub pubublic_key_file -f feature");
        System.out.println("               -c count -d date [ -in signature_file ]");
        System.out.println();
        System.out.println("   ex: program -genkey -priv priv.key -pub pub.key");
        System.out.println("       program -sign -priv priv.key -f AC_NUMBER_OF_USERS");
        System.out.println("               -c 50 -d 2050-12-30 -out license.sig");
        System.out.println("       program -verify -pub pub.key -f NMS_MANAGED_DEVICES");
        System.out.println("               -c 5000 -d 2050-12-30 -in license2.sig");
    }

    private static byte[] readFromStream(InputStream stream) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(stream));
        String s = r.readLine();
        return s.getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateKeys() throws Throwable {
        System.out.println("Generating keys...");
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.genKeyPair();
        System.out.println("Saving public key to " + publicKeyFile + "...");
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(keyPair.getPublic().getEncoded());
        byte[] publicKey = Base64.encodeBase64(x509EncodedKeySpec.getEncoded());
        FileOutputStream pubFile = new FileOutputStream(publicKeyFile);
        try {
            pubFile.write(publicKey);
        }
        finally {
            pubFile.close();
        }
        System.out.println("Saving private key to " + privateKeyFile + "...");
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(keyPair.getPrivate().getEncoded());
        byte[] privateKey = Base64.encodeBase64(pkcs8EncodedKeySpec.getEncoded());
        FileOutputStream privFile = new FileOutputStream(privateKeyFile);
        try {
            privFile.write(privateKey);
        }
        finally {
            privFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateSignature(String privateKeyFile, String feature, Long count, Date expiryDate) throws Throwable {
        byte[] privateKeyBin;
        FileInputStream privFile = new FileInputStream(privateKeyFile);
        try {
            privateKeyBin = Signer.readFromStream(privFile);
        }
        finally {
            privFile.close();
        }
        return Signer.generateSignature(privateKeyBin, feature, count, expiryDate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateSignature(byte[] privateKeyBin, String pFeature, Long pCount, Date pExpiryDate) throws Throwable {
        String result = null;
        System.out.println("Signing license...");
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64(privateKeyBin));
        PrivateKey privateKey = KeyFactory.getInstance("RSA").generatePrivate(pkcs8EncodedKeySpec);
        String data = new String(pFeature.getBytes("UTF-8")) + Long.toHexString(pCount) + Long.toHexString(pExpiryDate.getTime());
        Signature sigAlg = Signature.getInstance("SHA1withRSA");
        sigAlg.initSign(privateKey);
        sigAlg.update(data.getBytes());
        byte[] signature = sigAlg.sign();
        result = new String(Base64.encodeBase64(signature));
        if (signatureFile == null) {
            System.out.println("Signature:");
            System.out.println(result);
        } else {
            System.out.println("Writing signature to " + signatureFile + "...");
            FileOutputStream sigFile = new FileOutputStream(signatureFile);
            try {
                sigFile.write(Base64.encodeBase64(signature));
            }
            finally {
                sigFile.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean verify() throws Throwable {
        byte[] sigBin;
        byte[] pubKeyBin;
        FileInputStream pubFile = new FileInputStream(publicKeyFile);
        try {
            pubKeyBin = Signer.readFromStream(pubFile);
        }
        finally {
            pubFile.close();
        }
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(Base64.decodeBase64(pubKeyBin));
        PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(publicKeySpec);
        String data = new String(feature.getBytes("UTF-8")) + Long.toHexString(count) + Long.toHexString(date.getTime());
        if (signatureFile == null) {
            System.out.println("Reading signature from stdin...");
            sigBin = Signer.readFromStream(System.in);
        } else {
            System.out.println("Reading signature from " + signatureFile + "...");
            FileInputStream sigFile = new FileInputStream(signatureFile);
            try {
                sigBin = Signer.readFromStream(sigFile);
            }
            finally {
                sigFile.close();
            }
        }
        Signature sigAlg = Signature.getInstance("SHA1withRSA");
        sigAlg.initVerify(publicKey);
        sigAlg.update(data.getBytes());
        boolean valid = sigAlg.verify(Base64.decodeBase64(sigBin));
        System.out.print("Result: ");
        System.out.println(valid);
        return valid;
    }

    private static enum Mode {
        UNKNOWN,
        GENKEY,
        SIGN,
        VERIFY;

    }
}

