/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMP.customTypes;

import org.apache.commons.cli.MissingArgumentException;

public class IPv4
implements Comparable<IPv4> {
    private static final int MASK = 256;
    private static final int PART_MAX = 255;
    private static final int IP_PARTS = 4;
    private int[] address = new int[4];

    public IPv4(String adr) throws MissingArgumentException {
        String[] t = adr.split("\\.");
        if (t.length != 4) {
            throw new IllegalArgumentException("Wrong representation of IPv4 Address");
        }
        for (int i = 0; i < 4; ++i) {
            int part = Integer.parseInt(t[i]);
            if (part > 255) {
                throw new IllegalArgumentException("IP address part cannot exceed 255");
            }
            this.address[i] = part;
        }
    }

    public IPv4(int[] adr) throws MissingArgumentException {
        if (adr.length != 4) {
            throw new MissingArgumentException("Wrong represantation of IPv4 Address");
        }
        for (int part : adr) {
            if (part <= 255) continue;
            throw new IllegalArgumentException("IP address part cannot exceed 255");
        }
        this.address = (int[])adr.clone();
    }

    public IPv4 next() throws MissingArgumentException {
        IPv4 newAddress = new IPv4(this.address);
        newAddress.address[3] = newAddress.address[3] + 1;
        int i = 3;
        while (i >= 0) {
            if (i > 0) {
                int n = i - 1;
                newAddress.address[n] = newAddress.address[n] + newAddress.address[i] / 256;
            }
            int n = i--;
            newAddress.address[n] = newAddress.address[n] % 256;
        }
        return newAddress;
    }

    public IPv4 previous() throws MissingArgumentException {
        IPv4 newAddress = new IPv4(this.address);
        newAddress.address[3] = newAddress.address[3] - 1;
        int i = 3;
        while (i >= 0) {
            if (i > 0) {
                int n = i - 1;
                newAddress.address[n] = newAddress.address[n] - (newAddress.address[i] < 0 ? 1 : 0);
            }
            int n = i;
            newAddress.address[n] = newAddress.address[n] + 256;
            int n2 = i--;
            newAddress.address[n2] = newAddress.address[n2] % 256;
        }
        return newAddress;
    }

    public int getPart(int i) {
        return this.address[i];
    }

    @Override
    public int compareTo(String adr) throws MissingArgumentException {
        IPv4 a2 = new IPv4(adr);
        return this.compareTo(a2);
    }

    @Override
    public int compareTo(int[] adr) throws MissingArgumentException {
        IPv4 a2 = new IPv4(adr);
        return this.compareTo(a2);
    }

    @Override
    public int compareTo(IPv4 a) {
        for (int i = 0; i < 4; ++i) {
            if (a.getPart(i) > this.address[i]) {
                return -1;
            }
            if (a.getPart(i) >= this.address[i]) continue;
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            sb.append(this.address[i]);
            if (i == 3) continue;
            sb.append(".");
        }
        return sb.toString();
    }

    public Boolean greaterThan(IPv4 a) {
        int c = this.compareTo(a);
        return c > 0;
    }
}

