/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMP.main;

import com.veraxsystems.simulatorSNMP.exceptions.StartFailException;
import com.veraxsystems.simulatorSNMP.main.MyOptions;
import com.veraxsystems.simulatorSNMP.tools.config.SimulatorConfiguration;
import com.veraxsystems.simulatorSNMP.tools.inetManager.NetInterfaceManager;
import com.veraxsystems.simulatorSNMP.tools.versioning.Version;
import com.veraxsystems.simulatorSNMPAgent.controller.MainController;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.Parser;
import org.apache.log4j.Logger;

public final class Main {
    private static Logger logger = Logger.getLogger(Main.class);
    private static final MyOptions OPTIONS = new MyOptions();
    private static final Parser PARSER = new GnuParser();
    public static final String APP_CONF = "app.conf";
    public static final String APP_ROOT = "app.root";
    public static final String APP_IFACES = "app.ifaces";
    public static final String APP_DEV = "app.dev";
    private static CommandLine cmd;
    private static MainController ctrl;
    private static PrintStream out;
    private static SimulatorConfiguration configuration;

    private Main() {
    }

    public static void main(String[] args) throws StartFailException, IOException {
        boolean startupCompleted = false;
        try {
            cmd = PARSER.parse(OPTIONS, args, false);
            if (cmd.hasOption("h")) {
                OPTIONS.printAvailableOption(out);
                System.exit(0);
            }
            configuration = cmd.hasOption("s") && new File(cmd.getOptionValue("s")).exists() ? SimulatorConfiguration.getConfiguration(cmd.getOptionValue("s")) : SimulatorConfiguration.getConfiguration();
            Main.configurePath();
            startupCompleted = Main.startSimulator(startupCompleted);
        }
        catch (ParseException exp) {
            if (!startupCompleted) {
                logger.fatal("Startup failed");
                logger.error("Parsing failed.  Reason: " + exp.getMessage());
            }
            logger.error(exp.getMessage());
            if (NetInterfaceManager.getSystem() == 3) {
                Runtime.getRuntime().exec(configuration.getEntry("APPLICATION_CONF") + File.separator + "stop");
            }
            Runtime.getRuntime().exit(1);
        }
    }

    private static void configurePath() {
        File f = new File(System.getProperty("user.dir"));
        if (!f.isDirectory()) {
            f = new File("");
        }
        configuration.setDefaultValue("APPLICATION_ROOT", f.getAbsolutePath());
        f = new File(f.getAbsolutePath() + File.separator + "conf");
        if (f.isDirectory()) {
            configuration.setDefaultValue("APPLICATION_CONF", f.getAbsolutePath());
        } else {
            configuration.setDefaultValue("APPLICATION_CONF", configuration.getEntry("APPLICATION_ROOT"));
        }
        configuration.setDefaultValue("SIMULATOR_CONFIG_FILE", configuration.getEntry("APPLICATION_CONF") + File.separator + "devices.conf.xml");
    }

    private static boolean startSimulator(boolean startupCompleted) throws StartFailException, IOException {
        File f;
        boolean started = startupCompleted;
        logger.info("************* Starting Verax SNMP Agent Simulator v." + Version.getVersionString() + " ******************");
        if (cmd.hasOption("c")) {
            configuration.setEntry("CREATE_INTERFACES", cmd.getOptionValue("c"));
        }
        logger.info("Using interface device: " + configuration.getEntry("PRIMARY_INTERFACE"));
        logger.debug("Execution path: " + System.getProperty("user.dir"));
        logger.debug("Root: " + configuration.getEntry("APPLICATION_ROOT"));
        logger.debug("Conf: " + configuration.getEntry("APPLICATION_CONF"));
        if (ctrl == null) {
            ctrl = new MainController(Integer.parseInt(configuration.getEntry("SERVER_PORT")));
            started = true;
            logger.debug("Simulator started");
            System.out.println("Verax SNMP Agent Simulator started.");
        }
        if ((f = new File(configuration.getEntry("SIMULATOR_CONFIG_FILE"))).exists()) {
            ctrl.loadfile(f.getAbsolutePath());
        }
        ctrl.begin();
        return started;
    }

    static {
        out = System.out;
    }
}

