/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMP.rmi.commands;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ExecutionStatus
implements Serializable {
    private static final long serialVersionUID = 2122610164584481493L;
    public static final int OK = 0;
    public static final int DEVICE_LIMIT_REACHED = 10;
    public static final int DEVICE_CREATION_FAILED = 20;
    public static final int DEVICE_START_FAILED = 21;
    public static final int DEVICE_STOP_FAILED = 22;
    public static final int ID_NOT_FOUND = 30;
    public static final int FILE_NOT_FOUND = 40;
    public static final int CANNOT_WRITE_FILE = 41;
    public static final int CANNOT_READ_FILE = 42;
    public static final int OBJECT_ALREADY_EXISTS = 50;
    public static final int OID_NOT_FOUND = 51;
    public static final int ERROR = -1;
    private int status = 0;
    private Map<String, String> errors = new HashMap<String, String>();

    public ExecutionStatus() {
    }

    public ExecutionStatus(int errorCode) {
        this();
        this.status = errorCode;
    }

    public String getMessage() {
        if (this.status == 0) {
            return "OK";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[Error]: ");
        for (String key : this.errors.keySet()) {
            sb.append(key);
            sb.append(": ");
            sb.append(this.errors.get(key));
            sb.append(",");
        }
        String result = sb.toString();
        return result.substring(0, result.length() - 1);
    }

    public void addMessage(String target, String message) {
        this.errors.put(target, message);
    }

    public boolean isExecutedCorrectly() {
        return this.status == 0;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public Map<String, String> getErrors() {
        return this.errors;
    }

    public void setErrors(Map<String, String> errors) {
        this.errors = errors;
    }
}

