/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMP.tools;

import java.util.HashMap;
import java.util.Map;

public final class SNMPTools {
    private static Map<String, OidWrapper> oidsCache = new HashMap<String, OidWrapper>();
    private static SNMPTools instance = new SNMPTools();

    private SNMPTools() {
    }

    public static int checkOid(String first, String second) {
        long[] firstNum = SNMPTools.getOidNumeric(first);
        long[] secNum = SNMPTools.getOidNumeric(second);
        for (int i = 0; i < firstNum.length && i < secNum.length; ++i) {
            long i1 = firstNum[i];
            long i2 = secNum[i];
            if (i1 > i2) {
                return 1;
            }
            if (i2 <= i1) continue;
            return -1;
        }
        if (firstNum.length > secNum.length) {
            return 1;
        }
        if (firstNum.length < secNum.length) {
            return -1;
        }
        return 0;
    }

    private static long[] getOidNumeric(String line) {
        String oid = line.split(" ")[0].substring(1);
        if (oidsCache.containsKey(oid)) {
            return oidsCache.get(oid).getArray();
        }
        String[] parts = oid.split("\\.");
        long[] numParts = new long[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            numParts[i] = Long.parseLong(parts[i]);
        }
        SNMPTools sNMPTools = instance;
        sNMPTools.getClass();
        oidsCache.put(oid, sNMPTools.new OidWrapper(numParts));
        return numParts;
    }

    private class OidWrapper {
        private long[] array;

        public OidWrapper(long[] array) {
            this.array = (long[])array.clone();
        }

        public long[] getArray() {
            return this.array;
        }
    }
}

