/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMP.tools.config;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import org.apache.log4j.Logger;

public final class SimulatorConfiguration {
    private static final String SIMULATOR_HOME = "SIMULATOR_HOME";
    private static final String CONF_FILE_PATH = "confFile.path";
    public static final String APPLICATION_ROOT = "APPLICATION_ROOT";
    public static final String APPLICATION_CONF_DIRECTORY = "APPLICATION_CONF";
    public static final String APPLICATION_DEVICE = "PRIMARY_INTERFACE";
    public static final String APPLICATION_INTERFACE_POLICY = "CREATE_INTERFACES";
    public static final String APPLICATION_PORT = "SERVER_PORT";
    public static final String APPLICATION_CONFIG_FILE = "SIMULATOR_CONFIG_FILE";
    public static final String COMMUNITY = "COMMUNITY";
    public static final String WRITE_COMMUNITY = "WRITE_COMMUNITY";
    private static final String COMMUNITY_PUBLIC = "public";
    private static final String COMMUNITY_PRIVATE = "private";
    private static final String PROPERTIES = "simulator.properties";
    public static final String APPLICATION_DEVICE_DIRECTORY = "APPLICATION_DEVICE";
    private static SimulatorConfiguration instance;
    private Map<String, String> configuration = new HashMap<String, String>();
    private Map<String, String> defaultConfiguration = new HashMap<String, String>();
    private static Logger logger;

    private SimulatorConfiguration(String path) {
        this.initializeDefaultConfiguration();
        try {
            this.loadConfiguration(path);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), e);
        }
    }

    private void initializeDefaultConfiguration() {
        this.defaultConfiguration.put(APPLICATION_DEVICE, "unknown");
        this.defaultConfiguration.put(APPLICATION_INTERFACE_POLICY, "1");
        this.defaultConfiguration.put(APPLICATION_PORT, "43500");
        this.defaultConfiguration.put(COMMUNITY, COMMUNITY_PUBLIC);
        this.defaultConfiguration.put(WRITE_COMMUNITY, COMMUNITY_PRIVATE);
    }

    private void loadConfiguration(String path) throws IOException {
        logger.debug("Loading simulator configuration from " + path);
        Properties configurationProps = new Properties();
        String confContent = new Scanner(new File(path)).useDelimiter("\\Z").next();
        configurationProps.load(new StringReader(confContent.replace("\\", "\\\\")));
        for (Object key : configurationProps.keySet()) {
            if (key.equals(SIMULATOR_HOME)) {
                this.setEntry(APPLICATION_ROOT, configurationProps.get(key).toString());
                this.setEntry(APPLICATION_CONF_DIRECTORY, configurationProps.get(key).toString() + File.separator + "conf");
                this.setEntry(APPLICATION_DEVICE_DIRECTORY, configurationProps.get(key).toString() + File.separator + "device");
                this.setEntry(APPLICATION_CONFIG_FILE, this.getEntry(APPLICATION_CONF_DIRECTORY) + File.separator + "devices.conf.xml");
                continue;
            }
            this.setEntry(key.toString(), configurationProps.get(key).toString());
        }
    }

    public static SimulatorConfiguration getConfiguration(String path) {
        if (instance == null) {
            instance = new SimulatorConfiguration(path);
        }
        return instance;
    }

    public static SimulatorConfiguration getConfiguration() {
        if (instance == null) {
            try {
                Properties props = SimulatorConfiguration.load(PROPERTIES);
                String sysRoot = System.getenv("systemroot");
                if (sysRoot == null) {
                    sysRoot = "";
                }
                String configFilePath = sysRoot + props.getProperty(CONF_FILE_PATH);
                instance = new SimulatorConfiguration(configFilePath);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), e);
            }
        }
        return instance;
    }

    public String getEntry(String key) {
        String value;
        if (this.configuration.containsKey(key) && (value = this.configuration.get(key)) != null && value.length() > 0) {
            logger.debug("Getting config: " + key + "=" + value);
            return value;
        }
        if (this.defaultConfiguration.containsKey(key)) {
            value = this.defaultConfiguration.get(key);
            logger.debug("Getting default config: " + key + "=" + value);
            return value;
        }
        return null;
    }

    public void setEntry(String key, String value) {
        this.configuration.put(key, value);
    }

    public void setDefaultValue(String key, String value) {
        this.defaultConfiguration.put(key, value);
    }

    public static Properties load(String propsName) throws IOException {
        Properties props = new Properties();
        URL url = ClassLoader.getSystemResource(propsName);
        props.load(url.openStream());
        return props;
    }

    static {
        logger = Logger.getLogger(SimulatorConfiguration.class);
    }
}

