/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMP.tools.inetManager;

import com.veraxsystems.simulatorSNMP.tools.config.SimulatorConfiguration;
import com.veraxsystems.simulatorSNMP.tools.inetManager.INetworkInterfaceManager;
import com.veraxsystems.simulatorSNMP.tools.inetManager.InterfaceCreationMode;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class NetInterfaceManager
implements INetworkInterfaceManager {
    private static final int MASK = 255;
    private static final int ADDRESS_PART_LENGTH = 4;
    private static final int NETMASK_LENGTH = 32;
    private static final String IP_ADDRESS_PATTERN = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})";
    public static final int WINDOWS = 1;
    public static final int MAC = 2;
    public static final int LINUX = 3;
    public static final int SOLARIS = 4;
    private static Logger logger = Logger.getLogger(NetInterfaceManager.class);
    private static int count = 1;
    private static Set<String> addressCache;
    private static final Object LOCK;
    private static final String SIMULATOR_HOME;
    private static final String INTERFACES_FILE = "created_interfaces.txt";
    private static final String NETSH_WINXP_IP_PART = "ip";
    private static final String NETSH_WIN7_IP_PART = "ipv4";
    private static String netshWinIpPart;
    private static InterfaceCreationMode interfacesCreationMode;
    private static SimulatorConfiguration configuration;

    public NetInterfaceManager(String address, String netmask) {
        if (addressCache == null) {
            addressCache = new HashSet<String>();
            NetInterfaceManager.resetAddressCache();
        }
        interfacesCreationMode = InterfaceCreationMode.createInterfaceCreationMode(Integer.parseInt(SimulatorConfiguration.getConfiguration().getEntry("CREATE_INTERFACES")));
        if (!this.checkInterface(address).booleanValue()) {
            String device = configuration.getEntry("PRIMARY_INTERFACE");
            this.createVirtualInterface(device, address, netmask);
        }
    }

    public static synchronized void resetAddressCache() {
        if (addressCache != null) {
            addressCache.clear();
        } else {
            addressCache = new HashSet<String>();
        }
        Enumeration<NetworkInterface> em = null;
        try {
            em = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            logger.error(e.getMessage(), e);
        }
        if (em != null) {
            while (em.hasMoreElements()) {
                Enumeration<InetAddress> aEm = em.nextElement().getInetAddresses();
                while (aEm.hasMoreElements()) {
                    addressCache.add(aEm.nextElement().toString().split("/")[1]);
                }
            }
        }
    }

    private Boolean checkInterface(String address) {
        boolean check = false;
        if (addressCache != null && addressCache.contains(address)) {
            check = true;
        }
        return check;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean createVirtualInterface(String dev, String ip, String mask) {
        int returnCode = -1;
        Object object = LOCK;
        synchronized (object) {
            logger.info("createVirtualInterface start, creationMode=" + (Object)((Object)interfacesCreationMode) + " , OS=" + NetInterfaceManager.getSystem());
            if (interfacesCreationMode != InterfaceCreationMode.NoCreation) {
                try {
                    switch (NetInterfaceManager.getSystem()) {
                        case 3: 
                        case 4: {
                            String applicationConfiguration = configuration.getEntry("APPLICATION_CONF");
                            logger.info(applicationConfiguration + "/vlan_up " + dev + " " + count + " " + ip + "/" + mask);
                            returnCode = NetInterfaceManager.runExternalTool(new String[]{applicationConfiguration + "/vlan_up", dev, count + "", ip, mask}, true);
                            break;
                        }
                        case 1: {
                            String decMask = NetInterfaceManager.convertCidrSubnetToDecimal(mask);
                            logger.info("netsh Interface " + netshWinIpPart + " add address" + " " + dev + " " + ip + " " + decMask);
                            returnCode = NetInterfaceManager.runExternalTool(new String[]{"netsh", "interface", netshWinIpPart, "add", "address", dev, ip, decMask});
                            if (returnCode != 0) break;
                            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(SIMULATOR_HOME + "/conf/" + INTERFACES_FILE, true)));
                            out.println(dev + "##" + ip + "##" + decMask);
                            out.close();
                        }
                    }
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), e);
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage(), e);
                }
                if (returnCode == 0 && addressCache != null) {
                    addressCache.add(ip);
                }
            }
            logger.info("createVirtualInterface finished");
        }
        return returnCode == 0;
    }

    private static int runExternalTool(String[] cmd) throws IOException, InterruptedException {
        return NetInterfaceManager.runExternalTool(cmd, false);
    }

    private static int runExternalTool(String[] cmd, boolean increaseCounter) throws IOException, InterruptedException {
        int returnCode = -1;
        Process p = null;
        if (increaseCounter) {
            ++count;
        }
        p = Runtime.getRuntime().exec(cmd);
        returnCode = p.waitFor();
        logger.info("External tool exited with code " + returnCode);
        if (returnCode != 0) {
            logger.error(NetInterfaceManager.convertStreamToString(p.getErrorStream()));
        }
        p.getErrorStream().close();
        p.getInputStream().close();
        p.getOutputStream().close();
        p.destroy();
        return returnCode;
    }

    private static String convertStreamToString(InputStream is) {
        try {
            return new Scanner(is).useDelimiter("\\A").next();
        }
        catch (NoSuchElementException e) {
            return "";
        }
    }

    public static int getSystem() {
        String os = System.getProperty("os.name").toLowerCase();
        logger.debug("OS: " + os);
        if (os.indexOf("win") >= 0) {
            if (netshWinIpPart == null) {
                netshWinIpPart = os.indexOf("xp") >= 0 || os.indexOf("2003") > 0 ? NETSH_WINXP_IP_PART : NETSH_WIN7_IP_PART;
            }
            return 1;
        }
        if (os.indexOf("mac") >= 0) {
            return 2;
        }
        if (os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0) {
            return 3;
        }
        if (os.indexOf("sunos") >= 0) {
            return 4;
        }
        return 0;
    }

    public static String convertCidrSubnetToDecimal(String cidr) {
        String result = cidr;
        if (!cidr.matches(IP_ADDRESS_PATTERN)) {
            try {
                int cidrNum = Integer.parseInt(cidr);
                int netmask = 0;
                for (int j = 0; j < cidrNum; ++j) {
                    netmask |= 1 << 31 - j;
                }
                int[] parts = NetInterfaceManager.toArray(netmask);
                result = parts[0] + "." + parts[1] + "." + parts[2] + "." + parts[3];
            }
            catch (NumberFormatException e) {
                logger.error("Invalid mask format: " + cidr + ", using 255.255.255.0");
                result = "255.255.255.0";
            }
        }
        return result;
    }

    public static int[] toArray(int val) {
        int[] ret = new int[4];
        for (int j = 3; j >= 0; --j) {
            int n = j;
            ret[n] = ret[n] | val >>> 8 * (3 - j) & 0xFF;
        }
        return ret;
    }

    public static void cleanVirtualInterfaces() {
        if (interfacesCreationMode == InterfaceCreationMode.CreateDelete) {
            logger.info("Cleaning virtual interfaces");
            int system = NetInterfaceManager.getSystem();
            if (system == 3 || system == 4) {
                String applicationConfiguration = configuration.getEntry("APPLICATION_CONF");
                try {
                    logger.info("Executing " + applicationConfiguration + "/vlan_down");
                    Runtime.getRuntime().exec(applicationConfiguration + "/vlan_down");
                }
                catch (IOException e) {
                    String s = "System couldn't clean up interfaces. It is suggested to do one of the following:\n1) run script: " + applicationConfiguration + "/vlan_down\n" + "2) run script: service simulatord stop";
                    logger.error(s, e);
                }
            } else if (system == 1) {
                NetInterfaceManager.cleanVirtualInterfacesWindows();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanVirtualInterfacesWindows() {
        BufferedReader reader = null;
        PrintWriter out = null;
        try {
            reader = new BufferedReader(new FileReader(SIMULATOR_HOME + "/conf/" + INTERFACES_FILE));
            String line = reader.readLine();
            HashSet<String> deleted = new HashSet<String>();
            HashSet<String> failed = new HashSet<String>();
            while (line != null) {
                try {
                    NetInterfaceManager.parseLine(line, deleted, failed);
                    line = reader.readLine();
                }
                catch (NoSuchElementException e) {
                    logger.error("Invalid entry in " + SIMULATOR_HOME + "/conf/" + INTERFACES_FILE, e);
                }
            }
            out = new PrintWriter(new BufferedWriter(new FileWriter(SIMULATOR_HOME + "/conf/" + INTERFACES_FILE, false)));
            for (String l : failed) {
                out.println(l);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), e);
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), e);
                }
            }
            if (out != null) {
                out.close();
            }
        }
    }

    private static void parseLine(String line, Set<String> deleted, Set<String> failed) throws IOException, InterruptedException {
        StringTokenizer tokenizer = new StringTokenizer(line, "##");
        String iface = tokenizer.nextToken();
        String address = tokenizer.nextToken();
        if (!deleted.contains(iface + " " + address)) {
            logger.info("netsh interface " + netshWinIpPart + " delete address " + iface + " addr=" + address);
            int result = NetInterfaceManager.runExternalTool(new String[]{"netsh", "interface", netshWinIpPart, "delete", "address", iface, "addr=" + address});
            if (result == 0) {
                deleted.add(iface + " " + address);
            } else {
                failed.add(line);
            }
        }
    }

    static {
        LOCK = new Object();
        SIMULATOR_HOME = SimulatorConfiguration.getConfiguration().getEntry("APPLICATION_ROOT");
        configuration = SimulatorConfiguration.getConfiguration();
    }
}

