/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMP.tools.licencing;

import com.veraxsystems.simulatorSNMP.tools.config.SimulatorConfiguration;
import com.veraxsystems.simulatorSNMP.tools.licencing.License;
import com.veraxsystems.simulatorSNMP.tools.licencing.LicenseManager;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Properties;
import org.apache.log4j.Logger;

public final class DeviceLimit {
    private static final int DEFAULT_LIMIT = 4;
    private static final String PROPERTIES = "simulator.properties";
    private static final String PUBLIC_KEY = "verax.licensePublicKey";
    private static final String LICENSE_FILENAME = "simulator-license.lic";
    private static final String LICENSE_FEATURE = "SNMPSIMULATOR_AGENTS";
    private static LicenseManager licenseManager = null;
    private static Logger logger = Logger.getLogger(DeviceLimit.class);
    private static License license = null;
    private static boolean licenceErrorLogged = false;
    private static boolean licenceStatusLogged = false;
    private static int registered = 0;

    private DeviceLimit() {
    }

    public static synchronized int availableCount() {
        int limit = DeviceLimit.getLimit();
        if (limit == 0) {
            return -1;
        }
        if (limit > DeviceLimit.getRegistered()) {
            return limit - DeviceLimit.getRegistered();
        }
        return 0;
    }

    private static void initializeLicenseManager() throws IOException {
        logger.info("Initializing license manager...");
        Properties props = SimulatorConfiguration.load(PROPERTIES);
        String publicKey = props.getProperty(PUBLIC_KEY);
        licenseManager = new LicenseManager(publicKey);
    }

    private static String loadLicence() throws IOException {
        String applicationConf = SimulatorConfiguration.getConfiguration().getEntry("APPLICATION_CONF");
        File f = new File(applicationConf + File.separator + LICENSE_FILENAME);
        String result = "";
        if (f.exists()) {
            RandomAccessFile file = null;
            try {
                file = new RandomAccessFile(f, "r");
                byte[] buffer = new byte[(int)f.length()];
                file.readFully(buffer);
                result = new String(buffer);
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                file.close();
            }
        } else {
            throw new IOException("License file not found in " + applicationConf + File.separator + LICENSE_FILENAME + ". The license file is not required for the free version of the Verax SNMP Agent Simulator. If you need to simulate more than " + 4 + " agents please contact Verax Systems for the commercial license.");
        }
        return result;
    }

    public static synchronized int getLimit() {
        int result;
        block15: {
            if (licenseManager == null) {
                try {
                    DeviceLimit.initializeLicenseManager();
                }
                catch (IOException e) {
                    logger.error("Failed to initialize license manager");
                    return 4;
                }
            }
            result = 4;
            if (license == null) {
                logger.debug("Parsing license file...");
                try {
                    License importedLicense;
                    license = importedLicense = licenseManager.importLicense(DeviceLimit.loadLicence());
                    if (license != null) {
                        logger.debug("Successfully parsed license file");
                    }
                }
                catch (Exception e) {
                    if (licenceErrorLogged) break block15;
                    logger.warn("Error while parsing license file: " + e.getMessage());
                    licenceErrorLogged = true;
                }
            }
        }
        if (license != null && license.getFeature().equals(LICENSE_FEATURE)) {
            license.updateStatus();
            switch (license.getLicenseStatus()) {
                case 1: {
                    result = license.getCount();
                    logger.info("License valid, available devices: " + license.getCount());
                    break;
                }
                case 0: {
                    if (licenceStatusLogged || licenceErrorLogged) break;
                    logger.warn("Invalid license file");
                    break;
                }
                case -1: {
                    if (licenceStatusLogged) break;
                    logger.warn("License has expired");
                }
            }
        } else if (!licenceStatusLogged && !licenceErrorLogged) {
            logger.error("Invalid license file");
        }
        licenceStatusLogged = true;
        return result;
    }

    public static void setRegistered(int registered) {
        DeviceLimit.registered = registered;
    }

    public static int getRegistered() {
        return registered;
    }

    public static String generateHardwareLicenseRequest() {
        return licenseManager.makeLicenseRequest();
    }
}

