/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMP.tools.licencing;

import com.veraxsystems.commons.license.HardwareLicenseManager;
import com.veraxsystems.commons.license.LicenseParamImpl;
import com.veraxsystems.commons.license.LicenseRequest;
import com.veraxsystems.commons.license.LicenseUtils;
import com.veraxsystems.commons.updater.utils.OssBssLicense;
import com.veraxsystems.simulatorSNMP.exceptions.ValidationException;
import com.veraxsystems.simulatorSNMP.tools.licencing.License;
import com.veraxsystems.simulatorSNMP.tools.versioning.Version;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.util.ObfuscatedString;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.X509EncodedKeySpec;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public class LicenseManager {
    private static final long[] KEYSTORE_PASSWORD = new long[]{503722133387537278L, 5892755500054212185L, 7415720239109223855L};
    private static final long[] CIPHER_PASSWORD = new long[]{3085183191137482288L, 103192124108114946L, 7735842609704889709L};
    private static final String SEC_HARDWARE_ADDRESSES = "SEC_HARDWARE_ADDRESSES";
    private static Logger logger = Logger.getLogger(LicenseManager.class);
    public static final String LICENSE_HARDWARE_ID_KEY = "LICENSE_CONTENT_HARDWARE_ID";
    public static final String LICENSE_GUID_KEY = "LICENSE_CONTENT_GUID";
    public static final String LICENSE_CONTENT_COUNT_KEY = "LICENSE_CONTENT_COUNT";
    public static final String LICENSE_CONTENT_EXPIRY_DATE_KEY = "LICENSE_CONTENT_EXPIRY_DATE";
    public static final String LICENSE_CONTENT_FEATURE_KEY = "LICENSE_CONTENT_FEATURE";
    public static final String LICENSE_CONTENT_ENCRYPTED_KEY = "LICENSE_CONTENT_ENCRYPTED";
    public static final String LICENSE_CONTENT_DESCRIPTION_KEY = "LICENSE_CONTENT_DESCRIPTION";
    public static final String LICENSE_CONTENT_VERSION_KEY = "LICENSE_CONTENT_VERSION";
    public static final String DEFAULT_LICENSE_SUBJECT = "OSS_BSS_LICENSE";
    private PublicKey publicKey;
    private HardwareLicenseManager hlm = new HardwareLicenseManager();
    private long[] cipherPassword = CIPHER_PASSWORD;
    private long[] keyStorePassword = KEYSTORE_PASSWORD;
    private String keyStoreAlias = "publicKeyStore";
    private String keyStore = "/store/thePublic.store";

    public LicenseManager() {
    }

    public LicenseManager(String publicKey) {
        this();
        this.setPublicKey(publicKey);
    }

    public License importLicense(String licenseB64) throws ParseException, IOException {
        logger.debug(" - start");
        byte[] decodedBytes = Base64.decodeBase64(licenseB64.getBytes());
        String license = new String(decodedBytes);
        logger.debug("installing license\n" + license);
        Properties inputProperties = new Properties();
        inputProperties.load(new StringReader(license));
        logger.debug("properties loaded");
        String licenseContent = inputProperties.getProperty("license_content");
        logger.debug("hw_license  : " + licenseContent);
        License result = new License();
        try {
            if (licenseContent != null) {
                result = this.processHardwareLicense(licenseContent, result);
            } else {
                inputProperties = new Properties();
                inputProperties.load(new StringReader(license.replace("\\", "\\\\")));
                logger.debug("properties loaded");
                licenseContent = inputProperties.getProperty("license_content");
                String feature = inputProperties.getProperty("feature");
                String count = inputProperties.getProperty("count");
                String guid = inputProperties.getProperty("guid");
                String expiryDate = inputProperties.getProperty("expiry_date");
                String encrypted = inputProperties.getProperty("signature");
                String description = inputProperties.getProperty("description");
                String hardwareId = inputProperties.getProperty("hardwareId");
                String version = "";
                if (inputProperties.containsKey("version")) {
                    version = inputProperties.getProperty("version");
                }
                logger.debug("data extracted");
                logger.debug("feature     : " + feature);
                logger.debug("count       : " + count);
                logger.debug("guid        : " + guid);
                logger.debug("expiry_date : " + expiryDate);
                logger.debug("encrypted   : " + encrypted);
                logger.debug("description : " + description);
                logger.debug("hw_id       : " + hardwareId);
                logger.info("Version: " + version);
                result.setContent(null);
                result.setCount(Integer.parseInt(count));
                result.setDescription(description);
                DateFormat formatter = OssBssLicense.getDateFormat();
                result.setExpiryDate(formatter.parse(expiryDate));
                result.setFeature(feature);
                result.setEncrypted(encrypted);
                result.setGuid(guid);
                result.setHardwareId(hardwareId);
                result.setVersion(version);
                result.setImportedOn(new Date());
            }
            if (result != null) {
                if (this.isValid(result)) {
                    logger.debug("License verified, setting status to enabled");
                    result.setLicenseStatus(1);
                } else {
                    logger.warn("License not verified, setting status to disabled");
                    result.setLicenseStatus(0);
                }
            }
            logger.debug("license entity configured");
        }
        catch (Exception e) {
            result = null;
            logger.error("Failed to import license", e);
        }
        return result;
    }

    private License processHardwareLicense(String licenseContent, License result) throws ValidationException, ParseException {
        String version;
        logger.debug("hardware license detected");
        LicenseParamImpl licPar = new LicenseParamImpl(new ObfuscatedString(this.cipherPassword).toString(), this.keyStoreAlias, null, new ObfuscatedString(this.keyStorePassword).toString(), this.keyStore, DEFAULT_LICENSE_SUBJECT, this.getClass());
        this.hlm = new HardwareLicenseManager();
        this.hlm.setLicenseParam(licPar);
        if (this.hlm.install(licenseContent)) {
            LicenseContent verifiedLicense;
            logger.debug("hardware license installed with HML ");
            try {
                verifiedLicense = this.hlm.verify();
            }
            catch (Exception e) {
                throw new ValidationException(e.getMessage(), e);
            }
            logger.debug("hardware license verified");
            Properties authProperties = (Properties)verifiedLicense.getExtra();
            Long countHw = new Long((String)authProperties.get(LICENSE_CONTENT_COUNT_KEY));
            String guidHw = (String)authProperties.get(LICENSE_GUID_KEY);
            String hardwareIdHw = (String)authProperties.get(LICENSE_HARDWARE_ID_KEY);
            DateFormat formatter = OssBssLicense.getDateFormat();
            Date expiryDateHw = formatter.parse(authProperties.getProperty(LICENSE_CONTENT_EXPIRY_DATE_KEY));
            String descriptionHw = (String)authProperties.get(LICENSE_CONTENT_DESCRIPTION_KEY);
            String feature = (String)authProperties.get(LICENSE_CONTENT_FEATURE_KEY);
            logger.debug("properties read from the license");
            result.setContent(licenseContent);
            result.setCount(countHw.intValue());
            result.setGuid(guidHw);
            result.setDescription(descriptionHw);
            result.setExpiryDate(expiryDateHw);
            result.setFeature(feature);
            result.setHardwareId(hardwareIdHw);
            result.setEncrypted(null);
            result.setImportedOn(new Date());
            version = "";
            if (authProperties.containsKey(LICENSE_CONTENT_VERSION_KEY)) {
                version = authProperties.getProperty(LICENSE_CONTENT_VERSION_KEY);
            }
        } else {
            return null;
        }
        result.setVersion(version);
        return result;
    }

    public final void setPublicKey(String encodedPublicKey) {
        try {
            logger.debug("using publicKey=>" + encodedPublicKey + "<");
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(Base64.decodeBase64(encodedPublicKey.getBytes()));
            this.publicKey = keyFactory.generatePublic(publicKeySpec);
        }
        catch (Exception e) {
            logger.error(e, e);
            this.publicKey = null;
        }
    }

    public boolean isValid(License license) {
        boolean result = false;
        try {
            result = license.getContent() != null && !license.getContent().isEmpty() ? this.checkHardwareLicense(license) : this.checkSoftwareLicense(license);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            result = false;
        }
        return result;
    }

    private boolean checkSoftwareLicense(License license) throws NoSuchAlgorithmException, InvalidKeyException, ParseException, UnsupportedEncodingException, SignatureException {
        DateFormat formatter = OssBssLicense.getDateFormat();
        logger.debug(String.format("trying to validate software license %s", license.getFeature()));
        logger.debug("feature  = " + license.getFeature());
        logger.debug("count    = " + license.getCount());
        logger.debug("exp.date = " + license.getExpiryDate());
        Signature sigAlg = Signature.getInstance("SHA1withRSA");
        sigAlg.initVerify(this.publicKey);
        Date formattedDate = formatter.parse(formatter.format(license.getExpiryDate()));
        String data = new String(license.getFeature().getBytes("UTF-8")) + Long.toHexString(license.getCount()) + Long.toHexString(formattedDate.getTime());
        logger.debug("data    = " + data);
        logger.debug("sig     = " + license.getEncrypted());
        sigAlg.update(data.getBytes());
        boolean result = sigAlg.verify(Base64.decodeBase64(license.getEncrypted().getBytes()));
        if (license.getVersion() != null && license.getVersion().length() > 0 && !Version.getVersionString().matches(license.getVersion())) {
            result = false;
            logger.warn("License isn't valid for this version of Simulator!");
            logger.warn("Simulator version: " + Version.getVersionString());
        }
        if (result) {
            logger.debug(String.format("software license %s verified successfully.", license.getFeature()));
        } else {
            logger.warn(String.format("software license %s invalid.", license.getFeature()));
        }
        return result;
    }

    private boolean checkHardwareLicense(License license) throws ValidationException, ParseException, SocketException {
        boolean result;
        LicenseContent verifiedLicense;
        DateFormat formatter = OssBssLicense.getDateFormat();
        logger.debug(String.format("hardware license %s detected", license.getFeature()));
        LicenseParamImpl licPar = new LicenseParamImpl(new ObfuscatedString(this.cipherPassword).toString(), this.keyStoreAlias, null, new ObfuscatedString(this.keyStorePassword).toString(), this.keyStore, DEFAULT_LICENSE_SUBJECT, this.getClass());
        this.hlm.setLicenseParam(licPar);
        this.hlm.install(license.getContent());
        logger.debug("hardware license installed with HML ");
        try {
            verifiedLicense = this.hlm.verify();
        }
        catch (Exception e) {
            throw new ValidationException(e.getMessage(), e);
        }
        Properties authProperties = (Properties)verifiedLicense.getExtra();
        Long count = new Long((String)authProperties.get(LICENSE_CONTENT_COUNT_KEY));
        String mac = authProperties.getProperty(SEC_HARDWARE_ADDRESSES);
        Date expiryDate = formatter.parse(authProperties.getProperty(LICENSE_CONTENT_EXPIRY_DATE_KEY));
        Date formattedDate = formatter.parse(formatter.format(license.getExpiryDate()));
        String feature = (String)authProperties.get(LICENSE_CONTENT_FEATURE_KEY);
        logger.debug(String.format("properties read from the license %s", license.getFeature()));
        if (count.intValue() != license.getCount()) {
            throw new ValidationException(String.format("Count mismatch - expected: %d, provided: %d", (long)count, license.getCount()));
        }
        if (!feature.equals(license.getFeature())) {
            throw new ValidationException(String.format("Feature mismatch - expected: %s, provided: %s", feature, license.getFeature()));
        }
        if (!expiryDate.equals(formattedDate)) {
            throw new ValidationException(String.format("Expiry date mismatch - expected: %s, provided: %s ", expiryDate.toString(), license.getExpiryDate().toString()));
        }
        if (mac != null && !mac.equals(LicenseUtils.getHardwareSignature())) {
            throw new ValidationException("Invalid hardware signature");
        }
        if (license.getVersion() != null && license.getVersion().length() > 0 && !Version.getVersionString().matches(license.getVersion())) {
            result = false;
            logger.warn("License isn't valid for this version of Simulator!");
        } else {
            logger.debug(String.format("hardware license %s verified successfully.", license.getFeature()));
            result = true;
        }
        return result;
    }

    public String makeLicenseRequest() {
        logger.debug("start");
        String result = "";
        try {
            Properties props = new Properties();
            props.put("SEC_SUBJECT", DEFAULT_LICENSE_SUBJECT);
            props.put(SEC_HARDWARE_ADDRESSES, LicenseUtils.getHardwareSignature());
            LicenseRequest lr = new LicenseRequest(new ObfuscatedString(this.cipherPassword).toString(), props);
            result = lr.getEncrypted();
            String hwId = LicenseUtils.getMd5Digest(result.replaceAll("\\s", ""));
            result = result + "\n hardwareId=" + hwId;
        }
        catch (Exception e) {
            logger.error(e, e);
            result = "unable to generate license request" + e.getMessage();
        }
        logger.debug("done: " + result);
        return result;
    }
}

