/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMPAgent;

import com.veraxsystems.simulatorSNMP.tools.config.SimulatorConfiguration;
import com.veraxsystems.simulatorSNMPAgent.custom.CustomCommandProcessor;
import com.veraxsystems.simulatorSNMPAgent.service.IOidDataService;
import java.io.File;
import java.io.IOException;
import java.net.BindException;
import org.apache.log4j.Logger;
import org.snmp4j.TransportMapping;
import org.snmp4j.agent.BaseAgent;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.mo.snmp.SnmpCommunityMIB;
import org.snmp4j.agent.mo.snmp.SnmpNotificationMIB;
import org.snmp4j.agent.mo.snmp.SnmpTargetMIB;
import org.snmp4j.agent.mo.snmp.VacmMIB;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.USM;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.Variable;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class Agent
extends BaseAgent {
    private static final String SECURITY_NAME = "cpublic";
    private static final String WRITE_SECURITY_NAME = "cprivate";
    private static final String GROUP_NAME = "v1v2group";
    private static final String READ_VIEW_FULL = "fullReadView";
    private static final String WRITE_VIEW_FULL = "fullWriteView";
    private static final String NOTIFY_VIEW_FULL = "fullNotifyView";
    private static final int SOCKET_TIMEOUT = 30000;
    private static final int BUFFER_SIZE = 1500;
    private static final int INBOUND_MESSAGE_SIZE = 1500;
    public static final int NO_ERROR = 0;
    public static final int ADDRESS_IN_USE = 1;
    public static final int CANNOT_ASSGIN_ADDRESS = 2;
    public static final int UNKNOWN_ERROR = 1000;
    private static final String CANNOT_ASSGIN_ADDRESS_MESSAGE = "Cannot assign requested address: Cannot bind";
    private static final String ADDRESS_IN_USE_MESSAGE = "Address already in use: Cannot bind";
    private Logger logger = Logger.getLogger(Agent.class);
    private String address;
    private int errorType;
    private String community;
    private String writeCommunity;

    public Agent(String address, String community, String writeCommunity) {
        super(new File("conf/tmp/conf." + address.replace('/', '_') + ".agent"), new File("conf/tmp/bootCounter." + address.replace('/', '_') + ".agent"), new CustomCommandProcessor(new OctetString(MPv3.createLocalEngineID())));
        this.address = address;
        this.community = community;
        this.writeCommunity = writeCommunity;
    }

    public Agent(String address) throws IOException {
        this(address, SimulatorConfiguration.getConfiguration().getEntry("COMMUNITY"), SimulatorConfiguration.getConfiguration().getEntry("WRITE_COMMUNITY"));
    }

    @Override
    protected void registerManagedObjects() {
    }

    public void registerManagedObject(ManagedObject mo) {
        try {
            this.server.register(mo, null);
        }
        catch (DuplicateRegistrationException ex) {
            this.logger.error("Agent[" + this.address + "] failed to register Managed Object. Managed Object registration attempt conflicts with an existing registration because their scopes overlap." + ex.getMessage());
        }
    }

    public void printRegistery() {
        this.logger.debug("register size: " + this.server.getRegistry().entrySet().size());
    }

    public void unregisterManagedObject() {
        this.server.getRegistry().clear();
    }

    public void unregisterManagedObject(MOGroup moGroup) {
        moGroup.unregisterMOs(this.server, this.getContext(moGroup));
    }

    @Override
    protected void addNotificationTargets(SnmpTargetMIB targetMIB, SnmpNotificationMIB notificationMIB) {
    }

    @Override
    protected void addViews(VacmMIB vacm) {
        vacm.addGroup(1, new OctetString(SECURITY_NAME), new OctetString(GROUP_NAME), 3);
        vacm.addGroup(2, new OctetString(SECURITY_NAME), new OctetString(GROUP_NAME), 3);
        vacm.addGroup(2, new OctetString(WRITE_SECURITY_NAME), new OctetString(GROUP_NAME), 3);
        vacm.addAccess(new OctetString(GROUP_NAME), new OctetString(this.community), 0, 1, 1, new OctetString(READ_VIEW_FULL), new OctetString(), new OctetString(NOTIFY_VIEW_FULL), 3);
        vacm.addAccess(new OctetString(GROUP_NAME), new OctetString(this.writeCommunity), 2, 1, 1, new OctetString(), new OctetString(WRITE_VIEW_FULL), new OctetString(NOTIFY_VIEW_FULL), 3);
        vacm.addViewTreeFamily(new OctetString(READ_VIEW_FULL), new OID("1.3"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString(WRITE_VIEW_FULL), new OID("1.3"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString(NOTIFY_VIEW_FULL), new OID("1.3"), new OctetString(), 1, 3);
    }

    @Override
    protected void addUsmUser(USM usm) {
    }

    @Override
    protected void initTransportMappings() throws IOException {
        this.transportMappings = new TransportMapping[1];
        DefaultUdpTransportMapping tm = new DefaultUdpTransportMapping(new UdpAddress(this.address));
        tm.setSocketTimeout(30000);
        tm.setReceiveBufferSize(1500);
        tm.setMaxInboundMessageSize(1500);
        this.transportMappings[0] = tm;
    }

    public void start() throws IOException {
        ((CustomCommandProcessor)this.getAgent()).setBaseAgent(this);
        try {
            this.init();
        }
        catch (BindException e) {
            this.errorType = e.getMessage().equals(ADDRESS_IN_USE_MESSAGE) ? 1 : (e.getMessage().equals(CANNOT_ASSGIN_ADDRESS_MESSAGE) ? 2 : 1000);
            throw e;
        }
        this.errorType = 0;
        this.addShutdownHook();
        this.getServer().addContext(new OctetString(this.community));
        if (!this.community.equals(this.writeCommunity)) {
            this.getServer().addContext(new OctetString(this.writeCommunity));
        }
        this.finishInit();
        this.run();
        this.sendColdStartNotification();
    }

    @Override
    protected void unregisterManagedObjects() {
    }

    @Override
    protected void addCommunities(SnmpCommunityMIB communityMIB) {
        Variable[] com2sec = new Variable[]{new OctetString(this.community), new OctetString(SECURITY_NAME), this.getAgent().getContextEngineID(), new OctetString(this.community), new OctetString(), new Integer32(3), new Integer32(1)};
        Object row = communityMIB.getSnmpCommunityEntry().createRow(new OctetString("public2public").toSubIndex(true), com2sec);
        communityMIB.getSnmpCommunityEntry().addRow(row);
        Variable[] com2sec2 = new Variable[]{new OctetString(this.writeCommunity), new OctetString(WRITE_SECURITY_NAME), this.getAgent().getContextEngineID(), new OctetString(this.writeCommunity), new OctetString(), new Integer32(3), new Integer32(1)};
        Object row2 = communityMIB.getSnmpCommunityEntry().createRow(new OctetString("private").toSubIndex(true), com2sec2);
        communityMIB.getSnmpCommunityEntry().addRow(row2);
    }

    public void setDataService(IOidDataService dataService) {
        ((CustomCommandProcessor)this.getAgent()).setDataService(dataService);
    }

    public String getAddress() {
        return this.address;
    }

    @Override
    public void stop() {
        if (this.agentState != 40) {
            this.agentState = 30;
        } else {
            super.stop();
        }
    }

    public int getErrorType() {
        return this.errorType;
    }
}

