/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMPAgent.controller;

import com.veraxsystems.simulatorSNMP.customTypes.IPv4;
import com.veraxsystems.simulatorSNMP.exceptions.DevicesLimitException;
import com.veraxsystems.simulatorSNMP.rmi.commands.ExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.dto.DeviceDTO;
import com.veraxsystems.simulatorSNMP.rmi.dto.TypeDTO;
import com.veraxsystems.simulatorSNMP.rmi.types.DeviceState;
import com.veraxsystems.simulatorSNMP.tools.FileTools;
import com.veraxsystems.simulatorSNMP.tools.config.SimulatorConfiguration;
import com.veraxsystems.simulatorSNMP.tools.inetManager.NetInterfaceManager;
import com.veraxsystems.simulatorSNMP.tools.licencing.DeviceLimit;
import com.veraxsystems.simulatorSNMPAgent.controller.IDevicesCollection;
import com.veraxsystems.simulatorSNMPAgent.controller.ISimulatorDevice;
import com.veraxsystems.simulatorSNMPAgent.controller.SimulatorDevice;
import com.veraxsystems.simulatorSNMPAgent.controller.xmlConfig.structure.Pair;
import com.veraxsystems.simulatorSNMPAgent.controller.xmlConfig.structure.XmlDeviceElement;
import com.veraxsystems.simulatorSNMPAgent.controller.xmlConfig.structure.XmlTypeElement;
import com.veraxsystems.simulatorSNMPAgent.dao.loader.SnmpFileWatcher;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.log4j.Logger;

public final class DevicesCollection
implements IDevicesCollection {
    private Logger logger = Logger.getLogger(DevicesCollection.class);
    private SnmpFileWatcher fileLoader = null;
    private Map<Integer, ISimulatorDevice> devices = new ConcurrentHashMap<Integer, ISimulatorDevice>();

    public DevicesCollection(String file) throws IOException {
        this.init(file);
    }

    public DevicesCollection(XmlTypeElement type) throws IOException {
        this.init(type.getFilepath());
        this.updateDevices(type.getDevices());
    }

    @Override
    public Boolean start(int id) throws IOException {
        ISimulatorDevice dev = this.devices.get(id);
        if (dev != null) {
            return dev.start();
        }
        return false;
    }

    @Override
    public Boolean stop(int id) {
        ISimulatorDevice dev = this.devices.get(id);
        if (dev != null) {
            return dev.stopSync();
        }
        return false;
    }

    @Override
    public boolean startAll() {
        boolean result = true;
        for (ISimulatorDevice instance : this.devices.values()) {
            try {
                instance.start();
            }
            catch (IOException e) {
                result = false;
                this.logger.error(e.getMessage(), e);
            }
        }
        return result;
    }

    @Override
    public Boolean stopAll() {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        ArrayList<StopRunner> runnables = new ArrayList<StopRunner>();
        for (ISimulatorDevice instance : this.devices.values()) {
            StopRunner r = new StopRunner(instance);
            runnables.add(r);
            Thread t = new Thread(r);
            threads.add(t);
            t.start();
        }
        boolean succeeded = true;
        for (Thread t : threads) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                this.logger.error(e.getMessage(), e);
                succeeded = false;
            }
        }
        for (StopRunner runnable : runnables) {
            succeeded &= runnable.result;
        }
        return succeeded;
    }

    @Override
    public TypeDTO getState() {
        TypeDTO result = new TypeDTO();
        result.setId(this.hashCode());
        result.setPath(this.fileLoader.getFile().getAbsolutePath());
        ArrayList<DeviceDTO> devicesState = new ArrayList<DeviceDTO>();
        for (ISimulatorDevice device : this.devices.values()) {
            devicesState.add(device.getState());
        }
        result.setDevices(devicesState);
        return result;
    }

    @Override
    public boolean remove(int id) {
        return this.remove(id, false);
    }

    @Override
    public boolean remove(int id, boolean sync) {
        if (this.devices.containsKey(id)) {
            ISimulatorDevice dev = this.devices.get(id);
            this.logger.warn("Removing agent: " + dev.getIpAddress() + "/" + dev.getPort());
            this.fileLoader.unregisterObserver(dev);
            if (sync) {
                dev.stopSync();
            } else {
                dev.stop();
            }
            dev = null;
            this.devices.remove(id);
            DeviceLimit.setRegistered(DeviceLimit.getRegistered() - 1);
            return true;
        }
        return false;
    }

    @Override
    public ExecutionStatus createOrUpdate(String address, String netmask, String port, DeviceState state, String community, String writeCommunity) {
        ArrayList<Pair<IPv4>> parsedIps = new ArrayList<Pair<IPv4>>();
        ArrayList<Pair<Integer>> parsedPorts = new ArrayList<Pair<Integer>>();
        ExecutionStatus result = XmlDeviceElement.processAddresses(address, port, parsedIps, parsedPorts);
        for (Pair pair : parsedIps) {
            for (Pair pair2 : parsedPorts) {
                this.processRange(netmask, state, result, (IPv4)pair.getV1(), (IPv4)pair.getV2(), (Integer)pair2.getV1(), (Integer)pair2.getV2(), community, writeCommunity);
            }
        }
        return result;
    }

    private void processRange(String netmask, DeviceState state, ExecutionStatus result, IPv4 ipStart, IPv4 ipEnd, int portStart, int portEnd, String community, String writeCommunity) {
        IPv4 adr = null;
        try {
            adr = new IPv4(ipStart.toString());
        }
        catch (MissingArgumentException e) {
            String msg = e.getMessage();
            this.logger.error(msg, e);
            result.addMessage("ipStart", "invalid.ip.address");
            result.setStatus(20);
            return;
        }
        try {
            ArrayList<Thread> threads = new ArrayList<Thread>();
            if (adr != null) {
                while (!adr.greaterThan(ipEnd).booleanValue()) {
                    Thread t = new Thread(new AddressStarterRunner(netmask, state, result, portStart, portEnd, adr, community, writeCommunity));
                    threads.add(t);
                    t.start();
                    adr = adr.next();
                }
            }
            for (Thread t : threads) {
                try {
                    t.join();
                }
                catch (InterruptedException e) {
                    this.logger.error(e.getMessage(), e);
                }
            }
        }
        catch (MissingArgumentException e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    private ExecutionStatus processSingleAddress(String netmask, DeviceState state, ExecutionStatus currentStatus, int portStart, int portEnd, IPv4 adr, String community, String writeCommunity) {
        ExecutionStatus result = currentStatus;
        new NetInterfaceManager(adr.toString(), netmask);
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = portStart; i <= portEnd; ++i) {
            Thread t = new Thread(new PortStarterRunner(result, netmask, state, adr, i, community, writeCommunity));
            threads.add(t);
            t.start();
        }
        for (Thread t : threads) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                this.logger.error(e.getMessage(), e);
            }
        }
        return result;
    }

    private synchronized ExecutionStatus processSinglePort(String netmask, DeviceState state, ExecutionStatus result, IPv4 adr, int port, String community, String writeCommunity) {
        ISimulatorDevice t = null;
        try {
            t = this.getSimulatorDevice(netmask, adr, port, community, writeCommunity);
            t.setLastPermissionToken(Calendar.getInstance().getTimeInMillis());
            if (state == DeviceState.running && t.getAgentState() != 40) {
                t.start();
            } else if (state == DeviceState.stopped && t.getAgentState() != 30) {
                t.stop();
            }
        }
        catch (DevicesLimitException exp) {
            String msg = "Devices limit has been reached (" + DeviceLimit.getLimit() + " devices). Creating agent dropped.";
            this.logger.error(msg, exp);
            result.setStatus(10);
        }
        catch (Exception exp) {
            String msg = "Error while creating device " + (t != null ? t.getIpAddress() : adr) + " for type #" + this.hashCode() + ": " + (exp.getMessage() != null ? exp.getMessage() : "");
            this.logger.error(msg, exp);
            result.setStatus(20);
        }
        return result;
    }

    private ISimulatorDevice getSimulatorDevice(String netmask, IPv4 adr, int port, String community, String writeCommunity) throws DevicesLimitException, IOException {
        ISimulatorDevice t = null;
        for (ISimulatorDevice instance : this.devices.values()) {
            if (!instance.getIpAddress().equals(adr.toString()) || !instance.getNetmask().equals(netmask) || !instance.getPort().equals(Integer.toString(port))) continue;
            t = instance;
            break;
        }
        if (t != null) {
            t = this.validateCommunity(community, t);
        }
        if (t == null) {
            this.logger.info("Adding agent: " + adr + "/" + port + "...");
            t = new SimulatorDevice(adr.toString(), netmask, Integer.toString(port), community, writeCommunity);
            this.devices.put(t.hashCode(), t);
            this.fileLoader.registerObserver(t);
            this.logger.info("Agent " + adr + "/" + port + " created successfully");
        }
        return t;
    }

    private ISimulatorDevice validateCommunity(String community, ISimulatorDevice t) {
        String curWriteCommunity;
        String curCommunity = t.getCommunity();
        if (curCommunity == null) {
            curCommunity = SimulatorConfiguration.getConfiguration().getEntry("COMMUNITY");
        }
        if ((curWriteCommunity = t.getWriteCommunity()) == null) {
            curWriteCommunity = SimulatorConfiguration.getConfiguration().getEntry("WRITE_COMMUNITY");
        }
        if (curCommunity == null) {
            curCommunity = SimulatorConfiguration.getConfiguration().getEntry("COMMUNITY");
        }
        if (!curCommunity.equals(community)) {
            t.stopSync();
            this.devices.remove(t);
            t = null;
        }
        return t;
    }

    @Override
    public void removeAll() {
        this.fileLoader.unregisterAllObserver();
        this.stopAll();
        this.devices.clear();
        DeviceLimit.setRegistered(0);
    }

    @Override
    public void init(String file) throws IOException {
        this.logger.debug("Initialize snmp records file loading: " + file);
        File f = FileTools.getFile(file);
        this.fileLoader = new SnmpFileWatcher(f.getAbsolutePath());
        this.fileLoader.start();
    }

    @Override
    public File getFile() {
        return this.fileLoader.getFile();
    }

    @Override
    public void finish() {
        this.fileLoader.unregisterAllObserver();
        this.fileLoader.interrupt();
        this.removeAll();
    }

    @Override
    public ISimulatorDevice getDevice(int id) {
        return this.devices.get(id);
    }

    @Override
    public Collection<ISimulatorDevice> getDevices() {
        return this.devices.values();
    }

    @Override
    public void removeOlder(long timeToken) {
        ArrayList<Integer> indToRemove = new ArrayList<Integer>();
        for (ISimulatorDevice device : this.devices.values()) {
            if (device.getLastPermissionToken() >= timeToken) continue;
            indToRemove.add(device.hashCode());
        }
        for (Integer idx : indToRemove) {
            this.remove(idx);
        }
    }

    @Override
    public void updateDevices(List<XmlDeviceElement> devices) throws IOException {
        for (XmlDeviceElement device : devices) {
            if (device.getState() == DeviceState.disabled) continue;
            this.createOrUpdate(device.getIp(), device.getNetmask(), device.getPort(), device.getState(), device.getCommunity(), device.getWriteCommunity());
        }
    }

    @Override
    public void removeDevices(List<XmlDeviceElement> devices) {
        for (XmlDeviceElement device : devices) {
            for (Integer key : this.devices.keySet()) {
                ISimulatorDevice simulatorDevice = this.devices.get(key);
                if (!device.getIp().equals(simulatorDevice.getIpAddress()) || !device.getPort().equals(simulatorDevice.getPort())) continue;
                this.remove(key, true);
            }
        }
    }

    @Override
    public ExecutionStatus updateOid(String oid, String newValue) {
        ExecutionStatus executionStatus = new ExecutionStatus();
        for (ISimulatorDevice device : this.devices.values()) {
            executionStatus = device.updateOid(oid, newValue, executionStatus);
        }
        return executionStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionStatus replaceOids(List<String> newValues) {
        ExecutionStatus executionStatus = new ExecutionStatus();
        for (ISimulatorDevice device : this.devices.values()) {
            executionStatus = device.updateOids(newValues, executionStatus);
        }
        StringBuilder builder = new StringBuilder();
        for (String line : newValues) {
            builder.append(line);
            builder.append("\n");
        }
        String newContent = builder.toString();
        this.fileLoader.allowChange();
        PrintWriter out = null;
        try {
            out = new PrintWriter(this.fileLoader.getFile().getAbsolutePath());
            out.print(newContent);
        }
        catch (FileNotFoundException e) {
            this.logger.error(e.getMessage(), e);
            executionStatus.setStatus(41);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return executionStatus;
    }

    @Override
    public void allowChange() {
        this.fileLoader.allowChange();
    }

    private class StopRunner
    implements Runnable {
        private ISimulatorDevice instance;
        private boolean result;

        public StopRunner(ISimulatorDevice instance) {
            this.instance = instance;
        }

        @Override
        public void run() {
            this.result = this.instance.stopSync();
        }
    }

    private class AddressStarterRunner
    implements Runnable {
        private String netmask;
        private DeviceState state;
        private ExecutionStatus result;
        private int portStart;
        private int portEnd;
        private IPv4 adr;
        private String community;
        private String writeCommunity;

        public AddressStarterRunner(String netmask, DeviceState state, ExecutionStatus result, int portStart, int portEnd, IPv4 adr, String community, String writeCommunity) {
            this.netmask = netmask;
            this.state = state;
            this.result = result;
            this.portStart = portStart;
            this.portEnd = portEnd;
            this.adr = adr;
            this.community = community;
            this.writeCommunity = writeCommunity;
        }

        @Override
        public void run() {
            DevicesCollection.this.logger.info("Processing " + this.adr.toString());
            DevicesCollection.this.processSingleAddress(this.netmask, this.state, this.result, this.portStart, this.portEnd, this.adr, this.community, this.writeCommunity);
        }
    }

    private class PortStarterRunner
    implements Runnable {
        private ExecutionStatus result;
        private String netmask;
        private DeviceState state;
        private IPv4 adr;
        private int port;
        private String community;
        private String writeCommunity;

        public PortStarterRunner(ExecutionStatus result, String netmask, DeviceState state, IPv4 adr, int port, String community, String writeCommunity) {
            this.result = result;
            this.netmask = netmask;
            this.state = state;
            this.adr = adr;
            this.port = port;
            this.community = community;
            this.writeCommunity = writeCommunity;
        }

        @Override
        public void run() {
            DevicesCollection.this.logger.info("Processing " + this.adr.toString() + ":" + this.port);
            DevicesCollection.this.processSinglePort(this.netmask, this.state, this.result, this.adr, this.port, this.community, this.writeCommunity);
        }
    }
}

