/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMPAgent.controller;

import com.veraxsystems.simulatorSNMP.exceptions.StartFailException;
import com.veraxsystems.simulatorSNMP.rmi.commands.BooleanExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.commands.ExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.commands.IntegerExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.commands.StringExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.commands.StringListExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.commands.TypeExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.commands.TypeListExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.dto.DeviceDTO;
import com.veraxsystems.simulatorSNMP.rmi.dto.TypeDTO;
import com.veraxsystems.simulatorSNMP.rmi.interfaces.IRMIController;
import com.veraxsystems.simulatorSNMP.rmi.types.DeviceState;
import com.veraxsystems.simulatorSNMP.tools.FileTools;
import com.veraxsystems.simulatorSNMP.tools.config.SimulatorConfiguration;
import com.veraxsystems.simulatorSNMP.tools.inetManager.NetInterfaceManager;
import com.veraxsystems.simulatorSNMP.tools.licencing.DeviceLimit;
import com.veraxsystems.simulatorSNMP.tools.versioning.Version;
import com.veraxsystems.simulatorSNMPAgent.controller.DevicesCollection;
import com.veraxsystems.simulatorSNMPAgent.controller.IController;
import com.veraxsystems.simulatorSNMPAgent.controller.IDevicesCollection;
import com.veraxsystems.simulatorSNMPAgent.controller.xmlConfig.loader.DevConfLoader;
import com.veraxsystems.simulatorSNMPAgent.controller.xmlConfig.saver.DevConfSaver;
import com.veraxsystems.simulatorSNMPAgent.controller.xmlConfig.structure.XmlDeviceElement;
import com.veraxsystems.simulatorSNMPAgent.controller.xmlConfig.structure.XmlTypeElement;
import com.veraxsystems.simulatorSNMPAgent.model.validator.TypeValidator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.log4j.Logger;

public class MainController
extends UnicastRemoteObject
implements IController,
IRMIController {
    private static final int BUFFER_SIZE = 1024;
    private static final int RETRY_SLEEP = 1000;
    private static final int STARTUP_RETRIES = 10;
    private static final String TYPE_ALREADY_EXISTS = "type.already.exists";
    private static final String FILEPATH = "filepath";
    private static final String ID_NOT_FOUND = "id.not.found";
    private static final String DEVICE_ID = "deviceId";
    private static final String FILE_NOT_FOUND = "file.not.found";
    private static final String TYPE_ID = "typeId";
    private static final String INVALID_CHARACTERS_IN_PATH = "invalid.characters.in.path";
    private static final String FILE_ALREADY_EXISTS = "file.already.exists";
    private static final String CANNOT_WRITE_FILE = "cannot.write.file";
    private static final String CANNOT_REMOVE_FILE = "cannot.remove.file";
    public static final String TYPE_NOT_FOUND = "type.not.found";
    public static final String VALUE_NOT_FOUND = "value.not.found";
    public static final String INVALID_NUMBER_FORMAT = "invalid.number.format";
    public static final String OID_NOT_FOUND = "oid.not.found";
    private static final String PATH = "path";
    private static final String README = "README.txt";
    private static final int SHUTDOWN_DELAY = 2000;
    private static final int FILE_WATCHER_PERIOD = 2000;
    private static Logger logger = Logger.getLogger(MainController.class);
    private static final long serialVersionUID = 5942528136016644410L;
    private Map<Integer, IDevicesCollection> deviceType = new HashMap<Integer, IDevicesCollection>();
    private Registry registry;
    private File deviceConfig;
    private boolean internalChangeOccured;
    private int port;
    private SimulatorConfiguration configuration = SimulatorConfiguration.getConfiguration();
    private Thread serverShutdown = new Thread(){

        @Override
        public void run() {
            try {
                1.sleep(2000L);
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), e);
            }
            System.exit(0);
        }
    };
    private ConfigWatcher configWatcher = new ConfigWatcher();

    public MainController() throws RemoteException, StartFailException {
        this(43500);
    }

    public MainController(int port) throws RemoteException, StartFailException {
        String address;
        this.port = port;
        try {
            address = InetAddress.getLocalHost().toString();
        }
        catch (Exception e) {
            logger.error("Cannot get localhost address. Review your network settings. Make sure if hostname has been specified (in /etc/hosts for Linux).", e);
            throw new StartFailException(e.getMessage(), e);
        }
        logger.info("Start RMI listener at: " + address + ":" + port);
        boolean succeeded = false;
        Throwable exception = null;
        for (int tries = 0; !succeeded && tries < 10; ++tries) {
            try {
                this.registry = LocateRegistry.createRegistry(port);
                this.registry.rebind("SimulatorSNMP:" + port, this);
                succeeded = true;
                continue;
            }
            catch (RemoteException e) {
                logger.error("Remote exception: " + e.getMessage());
                exception = e;
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e1) {
                    logger.error(e1.getMessage(), e1);
                }
            }
        }
        if (!succeeded) {
            if (exception == null) {
                throw new StartFailException("Failed to start simulator");
            }
            throw new StartFailException(exception.getMessage(), exception);
        }
    }

    public void loadFile() throws IOException {
        List<XmlTypeElement> types = DevConfLoader.load(this.deviceConfig.getAbsolutePath());
        this.removeUnusedAgents(types);
        for (XmlTypeElement type : types) {
            if (type.getState() != null && type.getState().equals("disabled")) continue;
            IDevicesCollection ic = null;
            try {
                ic = this.loadType(type, ic);
            }
            catch (IOException ex) {
                logger.error("The following SNMP record file does not exist: '" + type.getFilepath() + "'.");
            }
        }
        this.removeUnusedAgents();
    }

    private boolean removeUnusedAgents(List<XmlTypeElement> types) throws IOException {
        boolean succeeded = true;
        for (XmlTypeElement type : types) {
            File tFile = FileTools.getFile(type.getFilepath());
            for (IDevicesCollection instanceCollection : this.deviceType.values()) {
                if (!instanceCollection.getFile().equals(tFile)) continue;
                ArrayList<Integer> idsToRemove = new ArrayList<Integer>();
                List<DeviceDTO> dtos = instanceCollection.getState().getDevices();
                for (DeviceDTO dto : dtos) {
                    idsToRemove.add(dto.getId());
                }
                for (XmlDeviceElement deviceElement : type.getDevices()) {
                    try {
                        for (XmlDeviceElement splitElement : XmlDeviceElement.getSplitDevices(deviceElement)) {
                            int index = dtos.indexOf(splitElement);
                            if (index < 0) continue;
                            idsToRemove.remove((Object)dtos.get(index).getId());
                        }
                    }
                    catch (MissingArgumentException e) {
                        logger.error(e.getMessage(), e);
                        succeeded = false;
                    }
                }
                succeeded = this.removeIds(succeeded, instanceCollection, idsToRemove);
            }
        }
        return succeeded;
    }

    private boolean removeIds(boolean succeeded, final IDevicesCollection instanceCollection, List<Integer> idsToRemove) {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (final Integer id : idsToRemove) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    instanceCollection.remove(id, true);
                }
            });
            threads.add(t);
            t.start();
        }
        for (Thread t : threads) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), e);
                succeeded = false;
            }
        }
        return succeeded;
    }

    private void removeUnusedAgents() {
        for (IDevicesCollection insCol : this.deviceType.values()) {
            insCol.removeOlder(this.deviceConfig.lastModified());
        }
        logger.debug("Unused agents removed");
    }

    private IDevicesCollection loadType(XmlTypeElement type, IDevicesCollection ic) throws IOException {
        IDevicesCollection collection = ic;
        File tFile = FileTools.getFile(type.getFilepath());
        for (IDevicesCollection instanceCollection : this.deviceType.values()) {
            logger.debug("Path compare [" + instanceCollection.getFile().getAbsolutePath() + ";" + tFile.getAbsolutePath() + "]");
            if (instanceCollection.getFile().equals(tFile)) {
                collection = instanceCollection;
                logger.debug("Path is the same!");
                continue;
            }
            instanceCollection.removeDevices(type.getDevices());
        }
        if (collection == null) {
            logger.info("Create type: " + type.getFilepath());
            collection = new DevicesCollection(type.getFilepath());
            this.deviceType.put(collection.hashCode(), collection);
        }
        collection.updateDevices(type.getDevices());
        return collection;
    }

    @Override
    public void begin() {
        this.configWatcher.start();
    }

    public void end() {
        for (IDevicesCollection device : this.deviceType.values()) {
            device.finish();
        }
        this.deviceType.clear();
        try {
            this.registry.unbind("SimulatorSNMP:" + this.port);
        }
        catch (Exception e1) {
            logger.error(e1.getMessage(), e1);
        }
        NetInterfaceManager.cleanVirtualInterfaces();
    }

    public void setDeviceConfig(File deviceConfig) {
        this.deviceConfig = deviceConfig;
    }

    public File getDeviceConfig() {
        return this.deviceConfig;
    }

    @Override
    public BooleanExecutionStatus cmdHasTypeWithID(int typeId) throws RemoteException {
        return new BooleanExecutionStatus(this.deviceType.containsKey(typeId));
    }

    @Override
    public ExecutionStatus cmdRemove(int typeId, int deviceId) throws RemoteException {
        Boolean res = false;
        ExecutionStatus executionStatus = new ExecutionStatus();
        if (this.deviceType.containsKey(typeId)) {
            res = this.deviceType.get(typeId).remove(deviceId);
            if (!res.booleanValue()) {
                executionStatus.setStatus(30);
                executionStatus.addMessage(DEVICE_ID, ID_NOT_FOUND);
            }
        } else {
            executionStatus.setStatus(30);
            executionStatus.addMessage(TYPE_ID, ID_NOT_FOUND);
        }
        return executionStatus;
    }

    @Override
    public ExecutionStatus cmdRemove(int typeId) throws RemoteException {
        ExecutionStatus executionStatus = new ExecutionStatus();
        if (this.deviceType.containsKey(typeId)) {
            this.deviceType.get(typeId).removeAll();
            this.deviceType.remove(typeId);
        } else {
            executionStatus.setStatus(30);
            executionStatus.addMessage(TYPE_ID, ID_NOT_FOUND);
        }
        return executionStatus;
    }

    @Override
    public ExecutionStatus cmdAddType(String filepath) throws RemoteException {
        File file = new File(filepath);
        ExecutionStatus executionStatus = new ExecutionStatus();
        boolean notFound = true;
        for (IDevicesCollection type : this.deviceType.values()) {
            if (!type.getFile().equals(file.getAbsolutePath())) continue;
            notFound = false;
            break;
        }
        if (notFound) {
            try {
                DevicesCollection ic = new DevicesCollection(file.getAbsolutePath());
                this.deviceType.put(ic.hashCode(), ic);
                executionStatus = new IntegerExecutionStatus(ic.hashCode());
            }
            catch (IOException e) {
                logger.error(e.getMessage(), e);
                executionStatus.setStatus(40);
                executionStatus.addMessage(FILEPATH, FILE_NOT_FOUND);
            }
        } else {
            executionStatus.setStatus(50);
            executionStatus.addMessage(FILEPATH, TYPE_ALREADY_EXISTS);
        }
        return executionStatus;
    }

    @Override
    public ExecutionStatus cmdAddDevice(int typeId, String address, String netmask, String port, DeviceState state) throws RemoteException {
        return this.cmdAddDevice(typeId, address, netmask, port, state, null, null);
    }

    @Override
    public ExecutionStatus cmdAddDevice(int typeId, String address, String netmask, String port, DeviceState state, String community, String writeCommunity) throws RemoteException {
        ExecutionStatus res = new ExecutionStatus();
        if (this.deviceType.containsKey(typeId)) {
            res = this.deviceType.get(typeId).createOrUpdate(address, netmask, port, state, community, writeCommunity);
        } else {
            res.addMessage(TYPE_ID, ID_NOT_FOUND);
            res.setStatus(30);
        }
        return res;
    }

    @Override
    public ExecutionStatus cmdShutdown() throws RemoteException {
        this.configWatcher.stopWatcher();
        this.end();
        this.serverShutdown.start();
        return new ExecutionStatus();
    }

    @Override
    public StringExecutionStatus cmdGetWelcome() throws RemoteException {
        StringBuilder out = new StringBuilder("Connected to Verax SNMP Simulator v.");
        out.append(this.getVersionString().getResult());
        out.append("\nType HELP to display available commands.");
        if (DeviceLimit.getLimit() > 0) {
            out.append("\nMaximum number of devices limited by license terms is " + DeviceLimit.getLimit() + ".");
            out.append("\n" + DeviceLimit.availableCount() + " device(s) available.");
        }
        return new StringExecutionStatus(out.toString());
    }

    @Override
    public TypeExecutionStatus cmdGetState(int typeId) throws RemoteException {
        TypeDTO result = null;
        TypeExecutionStatus executionStatus = new TypeExecutionStatus();
        if (this.deviceType.containsKey(typeId)) {
            result = this.deviceType.get(typeId).getState();
            executionStatus.setResult(result);
        } else {
            executionStatus.setStatus(30);
            executionStatus.addMessage(TYPE_ID, ID_NOT_FOUND);
        }
        return executionStatus;
    }

    @Override
    public TypeListExecutionStatus cmdGetStates() throws RemoteException {
        ArrayList<TypeDTO> devs = new ArrayList<TypeDTO>();
        for (IDevicesCollection devCol : this.deviceType.values()) {
            devs.add(devCol.getState());
        }
        return new TypeListExecutionStatus(devs);
    }

    @Override
    public ExecutionStatus cmdStartAll(Integer typeId) throws IOException {
        boolean result = true;
        ExecutionStatus executionStatus = new ExecutionStatus();
        if (typeId instanceof Integer) {
            result &= this.deviceType.get(typeId).startAll();
        } else {
            for (IDevicesCollection type : this.deviceType.values()) {
                result &= type.startAll();
            }
        }
        if (!result) {
            executionStatus.setStatus(21);
        }
        return executionStatus;
    }

    @Override
    public ExecutionStatus cmdStopAll(Integer typeId) throws RemoteException {
        boolean result = true;
        if (typeId instanceof Integer) {
            this.deviceType.get(typeId).stopAll();
        } else {
            for (IDevicesCollection type : this.deviceType.values()) {
                result &= type.stopAll().booleanValue();
            }
        }
        ExecutionStatus status = null;
        status = result ? new ExecutionStatus() : new ExecutionStatus(22);
        return status;
    }

    @Override
    public ExecutionStatus cmdStartDevice(int typeId, int deviceId) throws IOException {
        ExecutionStatus executionStatus = new ExecutionStatus();
        IDevicesCollection devCol = this.deviceType.get(typeId);
        if (devCol != null) {
            if (!devCol.start(deviceId).booleanValue()) {
                executionStatus.setStatus(30);
                executionStatus.addMessage(DEVICE_ID, ID_NOT_FOUND);
            }
        } else {
            executionStatus.setStatus(30);
            executionStatus.addMessage(TYPE_ID, ID_NOT_FOUND);
        }
        return executionStatus;
    }

    @Override
    public ExecutionStatus cmdStopDevice(int typeId, int deviceId) throws RemoteException {
        ExecutionStatus executionStatus = new ExecutionStatus();
        IDevicesCollection devCol = this.deviceType.get(typeId);
        if (devCol != null) {
            if (!devCol.stop(deviceId).booleanValue()) {
                executionStatus.setStatus(30);
                executionStatus.addMessage(DEVICE_ID, ID_NOT_FOUND);
            }
        } else {
            executionStatus.setStatus(30);
            executionStatus.addMessage(TYPE_ID, ID_NOT_FOUND);
        }
        return executionStatus;
    }

    @Override
    public void loadfile(String path) throws IOException {
        this.setDeviceConfig(new File(path));
    }

    @Override
    public ExecutionStatus cmdSave(String path) throws RemoteException {
        return this.cmdSave(path, true);
    }

    @Override
    public ExecutionStatus cmdSave(String path, boolean backup) throws RemoteException {
        ExecutionStatus executionStatus = new ExecutionStatus();
        this.internalChangeOccured = true;
        try {
            String pathToSave = path;
            if (!(path instanceof String)) {
                pathToSave = this.deviceConfig.getAbsolutePath();
            }
            if (!backup || MainController.copyFile(new File(pathToSave), new File(pathToSave + "." + new Date().getTime()))) {
                for (IDevicesCollection devicesCollection : this.deviceType.values()) {
                    devicesCollection.allowChange();
                }
                DevConfSaver.save(new ArrayList<IDevicesCollection>(this.deviceType.values()), pathToSave);
            } else {
                executionStatus.setStatus(41);
                executionStatus.addMessage(PATH, CANNOT_WRITE_FILE);
            }
        }
        catch (IOException e) {
            logger.error("Cannot save current configuration in device configuration file.", e);
            executionStatus.setStatus(41);
            executionStatus.addMessage(PATH, CANNOT_WRITE_FILE);
        }
        return executionStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copyFile(File source, File dest) {
        FileInputStream is = null;
        OutputStream os = null;
        boolean result = false;
        try {
            int length;
            is = new FileInputStream(source);
            os = new FileOutputStream(dest);
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)is).read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }
            result = true;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), e);
        }
        finally {
            try {
                ((InputStream)is).close();
                os.close();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), e);
            }
        }
        return result;
    }

    @Override
    public StringExecutionStatus cmdDownloadTypeFile(int typeId) throws RemoteException {
        StringExecutionStatus result = null;
        TypeExecutionStatus typeExecutionStatus = this.cmdGetState(typeId);
        if (typeExecutionStatus.isExecutedCorrectly()) {
            TypeDTO type = typeExecutionStatus.getResult();
            String path = type.getPath();
            File file = new File(path);
            if (file.exists()) {
                try {
                    String content = new Scanner(file).useDelimiter("\\Z").next();
                    return new StringExecutionStatus(content);
                }
                catch (FileNotFoundException e) {
                    result = new StringExecutionStatus(40);
                    result.addMessage(TYPE_ID, FILE_NOT_FOUND);
                    logger.error(e.getMessage(), e);
                }
            } else {
                result = new StringExecutionStatus(40);
                result.addMessage(TYPE_ID, FILE_NOT_FOUND);
            }
        } else {
            result = new StringExecutionStatus(typeExecutionStatus.getStatus());
            result.setErrors(typeExecutionStatus.getErrors());
        }
        return result;
    }

    @Override
    public StringExecutionStatus getVersionString() {
        return new StringExecutionStatus(Version.getVersionString());
    }

    @Override
    public StringExecutionStatus cmdGenerateHardwareLicenceRequest() throws RemoteException {
        return new StringExecutionStatus(DeviceLimit.generateHardwareLicenseRequest());
    }

    @Override
    public ExecutionStatus cmdUploadTypeFile(String path, String content) throws RemoteException {
        ExecutionStatus executionStatus;
        if (path.contains("..") || path.contains("~")) {
            executionStatus = new ExecutionStatus(41);
            executionStatus.addMessage(PATH, INVALID_CHARACTERS_IN_PATH);
        } else {
            try {
                File file = new File(this.configuration.getEntry("APPLICATION_DEVICE"), path);
                if (file.exists()) {
                    executionStatus = new ExecutionStatus(41);
                    executionStatus.addMessage(PATH, FILE_ALREADY_EXISTS);
                    logger.warn("File " + file.getPath() + " already exists.");
                } else {
                    file.getParentFile().mkdirs();
                    file.createNewFile();
                    FileWriter fw = new FileWriter(file.getAbsoluteFile());
                    BufferedWriter bw = new BufferedWriter(fw);
                    bw.write(content);
                    bw.close();
                    fw.close();
                    executionStatus = new ExecutionStatus();
                }
            }
            catch (IOException e) {
                executionStatus = new ExecutionStatus(41);
                executionStatus.addMessage(PATH, CANNOT_WRITE_FILE);
                logger.error(e.getMessage(), e);
            }
        }
        return executionStatus;
    }

    @Override
    public BooleanExecutionStatus cmdValidateType(int typeId) throws RemoteException {
        String path = null;
        for (IDevicesCollection type : this.deviceType.values()) {
            TypeDTO dto = type.getState();
            if (dto.getId() != typeId) continue;
            path = dto.getPath();
            break;
        }
        BooleanExecutionStatus executionStatus = null;
        if (path == null) {
            executionStatus = new BooleanExecutionStatus(30);
            executionStatus.addMessage(TYPE_ID, ID_NOT_FOUND);
        } else {
            try {
                TypeValidator validator = new TypeValidator(path);
                HashMap<String, String> errors = new HashMap<String, String>();
                executionStatus = new BooleanExecutionStatus(validator.validate(errors));
                executionStatus.setErrors(errors);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), e);
                executionStatus = new BooleanExecutionStatus(42);
                executionStatus.addMessage(TYPE_ID, "cannot.read.file");
            }
        }
        return executionStatus;
    }

    @Override
    public StringListExecutionStatus cmdGetAvailableTypes() throws RemoteException {
        StringListExecutionStatus executionStatus;
        ArrayList<String> files = new ArrayList<String>();
        File root = new File(this.configuration.getEntry("APPLICATION_DEVICE"));
        if (root.exists()) {
            this.getAllFiles(root, files);
            executionStatus = new StringListExecutionStatus(files);
        } else {
            executionStatus = new StringListExecutionStatus(40);
        }
        return executionStatus;
    }

    private void getAllFiles(File directory, List<String> files) {
        if (directory.isDirectory()) {
            for (File file : directory.listFiles()) {
                if (file.isDirectory()) {
                    this.getAllFiles(file, files);
                    continue;
                }
                if (file.getName().equals(README)) continue;
                files.add(file.getAbsolutePath());
            }
        }
    }

    @Override
    public StringExecutionStatus cmdGetSimulatorHome() throws RemoteException {
        return new StringExecutionStatus(this.configuration.getEntry("APPLICATION_ROOT"));
    }

    @Override
    public ExecutionStatus cmdDeleteTypeFile(String path) throws RemoteException {
        ExecutionStatus result;
        File file = new File(path);
        if (!file.exists()) {
            file = new File(this.configuration.getEntry("APPLICATION_DEVICE") + File.separator + path);
        }
        if (file.delete()) {
            result = new ExecutionStatus();
        } else {
            result = new ExecutionStatus(41);
            result.addMessage(PATH, CANNOT_REMOVE_FILE);
        }
        return result;
    }

    @Override
    public ExecutionStatus cmdUpdateOid(int typeId, String oid, String newValue) {
        IDevicesCollection type = null;
        for (IDevicesCollection devType : this.deviceType.values()) {
            TypeDTO dto = devType.getState();
            if (dto.getId() != typeId) continue;
            type = devType;
            break;
        }
        return type.updateOid(oid, newValue);
    }

    @Override
    public ExecutionStatus cmdReplaceType(int typeId, String content) throws RemoteException {
        IDevicesCollection type = null;
        for (IDevicesCollection devType : this.deviceType.values()) {
            TypeDTO dto = devType.getState();
            if (dto.getId() != typeId) continue;
            type = devType;
            break;
        }
        return type.replaceOids(Arrays.asList(content.split("\n")));
    }

    private class ConfigWatcher
    extends Thread {
        private boolean alive = true;

        private ConfigWatcher() {
        }

        @Override
        public void run() {
            long lastModified = 0L;
            while (this.alive) {
                try {
                    if (MainController.this.internalChangeOccured && lastModified != MainController.this.deviceConfig.lastModified()) {
                        lastModified = MainController.this.deviceConfig.lastModified();
                        MainController.this.internalChangeOccured = false;
                    }
                    if (MainController.this.deviceConfig != null) {
                        if (lastModified < MainController.this.deviceConfig.lastModified()) {
                            logger.info("Loading configuration: " + MainController.this.deviceConfig.getAbsolutePath());
                            NetInterfaceManager.resetAddressCache();
                            MainController.this.loadFile();
                            lastModified = MainController.this.deviceConfig.lastModified();
                            logger.info("Configuration loaded");
                        }
                    } else {
                        logger.fatal("Cannot load devices configuration file (devices.conf.xml). SIMULATOR_HOME path specified in the main configuration file (/etc/verax.d/simulator.conf on UNIX, %SystemRoot%\\etc\\verax.d on Windows) may be invalid or file does not exist.");
                        this.alive = false;
                    }
                    ConfigWatcher.sleep(2000L);
                }
                catch (InterruptedException e) {
                    this.alive = false;
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }

        public void stopWatcher() {
            this.alive = false;
        }
    }
}

