/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMPAgent.controller;

import com.veraxsystems.simulatorSNMP.exceptions.DevicesLimitException;
import com.veraxsystems.simulatorSNMP.rmi.commands.ExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.dto.DeviceDTO;
import com.veraxsystems.simulatorSNMP.tools.licencing.DeviceLimit;
import com.veraxsystems.simulatorSNMPAgent.Agent;
import com.veraxsystems.simulatorSNMPAgent.controller.ISimulatorDevice;
import com.veraxsystems.simulatorSNMPAgent.dao.IOidDataDao;
import com.veraxsystems.simulatorSNMPAgent.dao.OidDataDAO;
import com.veraxsystems.simulatorSNMPAgent.model.IOIDModel;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.network.simulator.INetworkRecords;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.network.simulator.NetworkConfigLoader;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.network.simulator.NetworkRecords;
import com.veraxsystems.simulatorSNMPAgent.service.IOidDataService;
import com.veraxsystems.simulatorSNMPAgent.service.OidDataService;
import java.io.IOException;
import java.util.List;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.log4j.Logger;

public class SimulatorDevice
implements ISimulatorDevice {
    private static final int SLEEP = 1000;
    private static final int RETRIES = 10;
    private Logger logger = Logger.getLogger(SimulatorDevice.class);
    private Agent agent;
    private IOidDataDao dataDAO;
    private IOidDataService dataService;
    private String address;
    private String netmask;
    private String port;
    private String community;
    private String writeCommunity;
    private INetworkRecords networkRecords = null;
    private long permissionToken = 0L;

    public SimulatorDevice(String address, String netmask, String port, String community, String writeCommunity) throws DevicesLimitException, IOException {
        if (DeviceLimit.getLimit() != 0 && DeviceLimit.availableCount() <= 0) {
            throw new DevicesLimitException();
        }
        DeviceLimit.setRegistered(DeviceLimit.getRegistered() + 1);
        this.address = address;
        this.port = port;
        this.netmask = netmask;
        this.community = community;
        this.writeCommunity = writeCommunity;
        if (community != null && community.length() > 0) {
            if (writeCommunity == null || writeCommunity.length() == 0) {
                this.writeCommunity = community;
            }
            this.agent = new Agent(address + "/" + port, community, this.writeCommunity);
        } else {
            this.agent = new Agent(address + "/" + port);
        }
        NetworkConfigLoader netConfLoad = NetworkConfigLoader.getInstance();
        this.networkRecords = new NetworkRecords(address + '/' + netmask);
        List<String> ips = null;
        try {
            ips = netConfLoad.getIPSPermutated(address, port);
            for (int i = 0; i < ips.size(); ++i) {
                this.networkRecords.addIP(ips.get(i));
            }
        }
        catch (MissingArgumentException e) {
            this.logger.error(e.getMessage(), e);
        }
        this.dataDAO = new OidDataDAO(this.networkRecords);
        this.dataService = new OidDataService(this.dataDAO);
    }

    @Override
    public Boolean start() throws IOException {
        this.logger.debug("Agent: #" + this.hashCode() + "[" + this.agent.getAddress() + "] starting.");
        if (this.agent.getAgentState() == 40) {
            this.logger.warn("Agent: #" + this.hashCode() + "[" + this.agent.getAddress() + "] is  running.");
        } else {
            this.agent.setDataService(this.dataService);
            boolean success = false;
            int tries = 0;
            while (!success) {
                try {
                    ++tries;
                    this.agent.start();
                    this.logger.info("Agent: #" + this.hashCode() + "[" + this.agent.getAddress() + "] started.");
                    success = true;
                }
                catch (IOException e) {
                    this.logger.warn("Tries: " + tries);
                    if (tries <= 10) {
                        this.logger.warn("Error while starting agent [" + this.address + "], retrying");
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e1) {
                            this.logger.error(e1.getMessage(), e1);
                        }
                        continue;
                    }
                    this.logger.error("Error while starting agent [" + this.address + "]: " + e.getMessage(), e);
                    throw e;
                }
            }
        }
        return true;
    }

    @Override
    public Boolean stop() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                SimulatorDevice.this.stopAgent();
            }
        }).start();
        return true;
    }

    @Override
    public Boolean stopSync() {
        return this.stopAgent();
    }

    @Override
    public List<IOIDModel> getErrors() {
        return this.getDataService().getErrors();
    }

    @Override
    public DeviceDTO getState() {
        DeviceDTO result = new DeviceDTO();
        result.setId(this.hashCode());
        result.setAddress(this.address);
        result.setNetmask(this.netmask);
        result.setPort(this.port);
        if (this.agent.getAgentState() == 0) {
            result.setState("Initialized");
        } else if (this.agent.getAgentState() == 10) {
            switch (this.agent.getErrorType()) {
                case 1: {
                    result.setState("Cannot bind");
                    break;
                }
                case 2: {
                    result.setState("No interface");
                    break;
                }
                default: {
                    result.setState("Ready");
                    break;
                }
            }
        } else if (this.agent.getAgentState() == 20) {
            result.setState("Finished");
        } else if (this.agent.getAgentState() == 40) {
            result.setState("Running");
        } else if (this.agent.getAgentState() == 30) {
            result.setState("Stopped");
        } else {
            result.setState("Unknown");
        }
        result.setAgentAddress(this.agent.getAddress());
        result.setAvailableInterfaces(this.networkRecords.getIPList());
        return result;
    }

    @Override
    public int getAgentState() {
        return this.agent.getAgentState();
    }

    @Override
    public void setLastPermissionToken(long lastUpdate) {
        this.permissionToken = lastUpdate;
    }

    @Override
    public long getLastPermissionToken() {
        return this.permissionToken;
    }

    @Override
    public void setDataDAO(IOidDataDao dataDAO) {
        this.dataDAO = dataDAO;
    }

    @Override
    public IOidDataDao getDataDAO() {
        return this.dataDAO;
    }

    @Override
    public void setDataService(IOidDataService dataService) {
        this.dataService = dataService;
    }

    @Override
    public IOidDataService getDataService() {
        return this.dataService;
    }

    @Override
    public String getIpAddress() {
        return this.address;
    }

    @Override
    public String getNetmask() {
        return this.netmask;
    }

    @Override
    public String getPort() {
        return this.port;
    }

    @Override
    public String getCommunity() {
        return this.community;
    }

    public void setCommunity(String community) {
        this.community = community;
    }

    private boolean stopAgent() {
        this.logger.debug("Stopping agent #" + this.hashCode() + "[" + this.agent.getAddress() + "].");
        if (this.agent.getAgentState() != 30) {
            try {
                this.agent.unregisterManagedObject();
                this.agent.setDataService(null);
                this.agent.stop();
                if (this.agent.getAgentState() == 30) {
                    this.logger.info("Agent #" + this.hashCode() + "[" + this.agent.getAddress() + "] stopped.");
                }
                return true;
            }
            catch (Exception ex) {
                this.logger.error("Could not stop agent #" + this.hashCode() + " [" + this.agent.getAddress() + "]", ex);
            }
        } else {
            this.logger.warn("Agent #" + this.hashCode() + "[" + this.agent.getAddress() + "] is currently stopped.");
        }
        return false;
    }

    @Override
    public ExecutionStatus updateOid(String oid, String newValue, ExecutionStatus executionStatus) {
        return this.dataDAO.updateOid(oid, newValue);
    }

    @Override
    public ExecutionStatus updateOids(List<String> newValues, ExecutionStatus executionStatus) {
        return this.dataDAO.updateOids(newValues);
    }

    @Override
    public String getWriteCommunity() {
        return this.writeCommunity;
    }
}

