/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMPAgent.controller.xmlConfig.loader;

import com.veraxsystems.simulatorSNMPAgent.controller.xmlConfig.structure.XmlTypeElement;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class DevConfLoader {
    private static Logger logger = Logger.getLogger(DevConfLoader.class);

    private DevConfLoader() {
    }

    public static List<XmlTypeElement> load(String filepath) {
        ArrayList<XmlTypeElement> types = new ArrayList<XmlTypeElement>();
        File xmlFile = new File(filepath);
        if (xmlFile.exists()) {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(xmlFile);
                doc.getDocumentElement().normalize();
                NodeList nl = doc.getElementsByTagName("type");
                logger.debug("Type nodes count: " + nl.getLength());
                for (int i = 0; i < nl.getLength(); ++i) {
                    try {
                        types.add(XmlTypeElement.parseNode(nl.item(i), true));
                        continue;
                    }
                    catch (IOException exp) {
                        logger.fatal(exp.getMessage());
                        logger.fatal("Corrupted type will be removed from the configuration file");
                        logger.error(exp.getMessage(), exp);
                    }
                }
                logger.debug("Configuration loaded!");
            }
            catch (ParserConfigurationException exp) {
                logger.fatal(exp.getMessage());
            }
            catch (SAXException exp) {
                logger.fatal(exp.getMessage());
            }
            catch (IOException exp) {
                logger.fatal(exp.getMessage());
            }
        }
        return types;
    }
}

