/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMPAgent.controller.xmlConfig.saver;

import com.veraxsystems.simulatorSNMP.rmi.types.DeviceState;
import com.veraxsystems.simulatorSNMP.tools.config.SimulatorConfiguration;
import com.veraxsystems.simulatorSNMPAgent.controller.IDevicesCollection;
import com.veraxsystems.simulatorSNMPAgent.controller.ISimulatorDevice;
import com.veraxsystems.simulatorSNMPAgent.controller.xmlConfig.saver.setMap.SetElement;
import com.veraxsystems.simulatorSNMPAgent.controller.xmlConfig.saver.setMap.SetInfo;
import com.veraxsystems.simulatorSNMPAgent.controller.xmlConfig.saver.setMap.Subset;
import com.veraxsystems.simulatorSNMPAgent.controller.xmlConfig.saver.unifieders.IDeviceUnified;
import com.veraxsystems.simulatorSNMPAgent.controller.xmlConfig.saver.unifieders.IpDeviceUnified;
import com.veraxsystems.simulatorSNMPAgent.controller.xmlConfig.saver.unifieders.PortDeviceUnified;
import com.veraxsystems.simulatorSNMPAgent.controller.xmlConfig.structure.Pair;
import com.veraxsystems.simulatorSNMPAgent.controller.xmlConfig.structure.XmlDeviceElement;
import com.veraxsystems.simulatorSNMPAgent.controller.xmlConfig.structure.XmlTypeElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public final class CollectionTransform {
    private static Logger logger = Logger.getLogger(CollectionTransform.class);
    private static String defaultCommunity = SimulatorConfiguration.getConfiguration().getEntry("COMMUNITY");

    private CollectionTransform() {
    }

    public static List<XmlTypeElement> toXml(List<IDevicesCollection> typeCollection) {
        ArrayList<XmlTypeElement> xTypes = new ArrayList<XmlTypeElement>();
        for (IDevicesCollection devicesCollection : typeCollection) {
            XmlTypeElement xType = new XmlTypeElement();
            try {
                xType.setFilepath(devicesCollection.getFile().getAbsolutePath());
                ArrayList<Map<String, Map<String, List<ISimulatorDevice>>>> devCat = new ArrayList<Map<String, Map<String, List<ISimulatorDevice>>>>();
                devCat.add(new HashMap());
                devCat.add(new HashMap());
                CollectionTransform.buildDevicesCollection(devicesCollection, devCat);
                for (int i = 0; i < 2; ++i) {
                    for (String netmask : ((Map)devCat.get(i)).keySet()) {
                        for (String community : ((Map)((Map)devCat.get(i)).get(netmask)).keySet()) {
                            xType.addAllDevices(CollectionTransform.toXmlArray((List)((Map)((Map)devCat.get(i)).get(netmask)).get(community), netmask, i > 0 ? DeviceState.stopped : DeviceState.running, community));
                        }
                    }
                }
                if (((Map)devCat.get(0)).size() == 0) {
                    xType.setState("stopped");
                }
                xTypes.add(xType);
            }
            catch (IOException e) {
                logger.error("File does not exist: " + devicesCollection.getFile().getAbsolutePath());
            }
        }
        return xTypes;
    }

    private static void buildDevicesCollection(IDevicesCollection devicesCollection, List<Map<String, Map<String, List<ISimulatorDevice>>>> devCat) {
        for (ISimulatorDevice device : devicesCollection.getDevices()) {
            String community;
            int i;
            String nKey = device.getNetmask();
            int n = i = device.getAgentState() == 40 ? 0 : 1;
            if (!devCat.get(i).containsKey(nKey)) {
                devCat.get(i).put(nKey, new HashMap());
            }
            if ((community = device.getCommunity()) == null) {
                community = defaultCommunity;
            }
            if (!devCat.get(i).get(nKey).containsKey(community)) {
                devCat.get(i).get(nKey).put(community, new ArrayList());
            }
            devCat.get(i).get(nKey).get(community).add(device);
        }
    }

    private static SetInfo getMaxSet(int startPort, int startIp, SetElement[][] collection) {
        int curIp;
        SetInfo set = new SetInfo(startPort, startIp, startPort, startIp);
        int[] rows = new int[collection.length - startIp];
        for (curIp = startIp; curIp < collection.length && CollectionTransform.check(startPort, startIp, startPort, curIp, collection); ++curIp) {
            for (int curPort = startPort; curPort < collection[curIp].length && CollectionTransform.check(startPort, curIp, curPort, curIp, collection); ++curPort) {
                rows[curIp - startIp] = curPort - startPort + 1;
            }
        }
        int maxCount = rows[0];
        int selectedIps = 0;
        int selectedPorts = rows[0];
        int maxWidth = rows[0];
        for (int i = 1; i < curIp - startIp; ++i) {
            if (rows[i] <= maxWidth) {
                maxWidth = rows[i];
            }
            if (maxCount > (i + 1) * maxWidth) continue;
            maxCount = (i + 1) * maxWidth;
            selectedIps = i;
            selectedPorts = maxWidth;
        }
        set.setPortMax(set.getPortMin() + selectedPorts - 1);
        set.setIpMax(set.getIpMin() + selectedIps);
        set.setItemCount((set.getPortMax() - set.getPortMin() + 1) * (set.getIpMax() - set.getIpMin() + 1));
        return set;
    }

    private static boolean check(int portMin, int ipMin, int portMax, int ipMax, SetElement[][] collection) {
        boolean result = true;
        for (int i = ipMin; i <= ipMax; ++i) {
            for (int j = portMin; j <= portMax; ++j) {
                if (collection[i][j] != null && collection[i][j].isEnabled()) continue;
                result = false;
            }
        }
        return result;
    }

    private static String getIpRange(SetInfo fSet, IDeviceUnified ips) {
        String out;
        if (fSet.getIpMin() == fSet.getIpMax()) {
            out = (String)ips.getObject(fSet.getIpMin());
        } else {
            out = ips.getObject(fSet.getIpMin()) + "-";
            out = out + ips.getObject(fSet.getIpMax());
        }
        return out;
    }

    private static String getPortRange(SetInfo fSet, IDeviceUnified ports) {
        String out;
        if (fSet.getPortMin() == fSet.getPortMax()) {
            out = Long.toString((Long)ports.getObject(fSet.getPortMin()));
        } else {
            out = ports.getObject(fSet.getPortMin()) + "-";
            out = out + ports.getObject(fSet.getPortMax());
        }
        return out;
    }

    private static List<XmlDeviceElement> toXmlArray(List<ISimulatorDevice> devices, String netmask, DeviceState state, String community) {
        ArrayList<XmlDeviceElement> xDevices = new ArrayList<XmlDeviceElement>();
        IpDeviceUnified ips = new IpDeviceUnified(devices);
        PortDeviceUnified ports = new PortDeviceUnified(devices);
        int ipsCount = ips.getValuesCount();
        int portsCount = ports.getValuesCount();
        SetElement[][] mainSet = new SetElement[ipsCount][portsCount];
        ArrayList<Subset> subsets = new ArrayList<Subset>();
        int elementsLeft = 0;
        for (ISimulatorDevice dev : devices) {
            int n1 = ips.getHash(dev.getIpAddress());
            int m1 = ports.getHash(dev.getPort());
            mainSet[n1][m1] = new SetElement(n1, m1);
            ++elementsLeft;
        }
        CollectionTransform.createSubsets(ipsCount, portsCount, mainSet, subsets, elementsLeft);
        Collections.sort(subsets);
        List<Pair<String>> groupDev = CollectionTransform.groupDevices(ips, ports, subsets);
        CollectionTransform.mergeDuplicates(groupDev);
        for (Pair<String> tDev : groupDev) {
            if (tDev.getV1() == null || tDev.getV2() == null) continue;
            XmlDeviceElement xDevice = new XmlDeviceElement();
            xDevice.setNetmask(netmask);
            xDevice.setState(state);
            xDevice.setIp(tDev.getV1());
            xDevice.setPort(tDev.getV2());
            if (community != null && !community.equals(defaultCommunity)) {
                xDevice.setCommunity(community);
            }
            xDevices.add(xDevice);
        }
        return xDevices;
    }

    private static void createSubsets(int ipsCount, int portsCount, SetElement[][] mainSet, List<Subset> subsets, int elementsLeft) {
        int elementsToProcess = elementsLeft;
        while (elementsToProcess > 0) {
            int j;
            SetInfo set = new SetInfo(0, 0, 0, 0);
            for (int i = 0; i < ipsCount; ++i) {
                for (j = 0; j < portsCount; ++j) {
                    if (mainSet[i][j] == null || !mainSet[i][j].isEnabled()) continue;
                    SetInfo currSet = CollectionTransform.getMaxSet(j, i, mainSet);
                    if (set.getItemCount() >= currSet.getItemCount()) continue;
                    set = currSet;
                }
            }
            Subset subset = new Subset();
            subsets.add(subset);
            subset.setParam(set);
            for (j = set.getIpMin(); j <= set.getIpMax(); ++j) {
                for (int i = set.getPortMin(); i <= set.getPortMax(); ++i) {
                    mainSet[j][i].setSubset(subset);
                    --elementsToProcess;
                }
            }
        }
    }

    private static void mergeDuplicates(List<Pair<String>> groupDev) {
        for (int elPos = 0; elPos < groupDev.size(); ++elPos) {
            int elJoin = elPos + 1;
            while (elJoin < groupDev.size()) {
                if (groupDev.get(elPos).getV2().compareTo(groupDev.get(elJoin).getV2()) == 0) {
                    groupDev.get(elPos).setV1(groupDev.get(elPos).getV1() + ',' + groupDev.get(elJoin).getV1());
                    groupDev.remove(elJoin);
                    continue;
                }
                ++elJoin;
            }
        }
    }

    private static List<Pair<String>> groupDevices(IDeviceUnified ips, IDeviceUnified ports, List<Subset> subsets) {
        ArrayList<Pair<String>> groupDev = new ArrayList<Pair<String>>();
        for (Subset subset : subsets) {
            SetInfo fSet = subset.getParam();
            String sIp = CollectionTransform.getIpRange(fSet, ips);
            String sPorts = CollectionTransform.getPortRange(fSet, ports);
            boolean attached = false;
            for (Pair pair : groupDev) {
                if (((String)pair.getV1()).compareTo(sIp) != 0) continue;
                pair.setV2((String)pair.getV2() + ',' + sPorts);
                attached = true;
                break;
            }
            if (attached) continue;
            groupDev.add(new Pair<String>(sIp, sPorts));
        }
        return groupDev;
    }
}

