/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMPAgent.controller.xmlConfig.saver;

import com.veraxsystems.simulatorSNMP.rmi.types.DeviceState;
import com.veraxsystems.simulatorSNMP.tools.FileTools;
import com.veraxsystems.simulatorSNMPAgent.controller.IDevicesCollection;
import com.veraxsystems.simulatorSNMPAgent.controller.xmlConfig.loader.DevConfLoader;
import com.veraxsystems.simulatorSNMPAgent.controller.xmlConfig.saver.CollectionTransform;
import com.veraxsystems.simulatorSNMPAgent.controller.xmlConfig.structure.XmlDeviceElement;
import com.veraxsystems.simulatorSNMPAgent.controller.xmlConfig.structure.XmlTypeElement;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.apache.log4j.Logger;

public final class DevConfSaver {
    private static Logger logger = Logger.getLogger(DevConfSaver.class);

    private DevConfSaver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(List<IDevicesCollection> typesCollection, String filepath) throws IOException {
        File file = new File(filepath);
        List<XmlTypeElement> toSave = CollectionTransform.toXml(typesCollection);
        DevConfSaver.compareConfiguration(file, toSave);
        FileWriter fstream = new FileWriter(file);
        PrintWriter out = new PrintWriter(fstream);
        try {
            DevConfSaver.writeFile(toSave, out);
            logger.info("Configuration saved in: " + filepath);
        }
        finally {
            out.close();
        }
    }

    private static void writeFile(List<XmlTypeElement> toSave, PrintWriter out) {
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<simulator.veraxsystems.com>");
        out.println("\t<types>");
        logger.debug("Total types to save:" + toSave.size());
        for (XmlTypeElement type : toSave) {
            out.print("\t\t<type filepath=\"" + type.getFilepath() + "\"");
            if (type.getState() instanceof String && type.getState().length() > 0) {
                out.print(" state=\"" + type.getState() + "\"");
            }
            out.println(">");
            out.println("\t\t\t<devices>");
            logger.debug("Devices to save within type:" + type.getDevices().size());
            for (XmlDeviceElement device : type.getDevices()) {
                out.print("\t\t\t\t<device ip=\"" + device.getSortedIP() + "\" netmask=\"" + device.getNetmask() + "\" port=\"" + device.getSortedPort() + "\"");
                if (device.getState() != DeviceState.running) {
                    out.print(" state=\"" + (Object)((Object)device.getState()) + "\"");
                }
                if (device.getCommunity() != null && device.getCommunity().length() > 0) {
                    out.print(" community=\"" + device.getCommunity() + "\"");
                }
                out.println("></device>");
            }
            out.println("\t\t\t</devices>");
            out.println("\t\t</type>");
        }
        out.println("\t</types>");
        out.println("</simulator.veraxsystems.com>");
    }

    private static void compareConfiguration(File file, List<XmlTypeElement> toSave) throws IOException {
        if (file.exists()) {
            List<XmlTypeElement> toCompare = DevConfLoader.load(file.getAbsolutePath());
            for (XmlTypeElement lType : toCompare) {
                boolean find = false;
                File lFile = FileTools.getFile(lType.getFilepath());
                for (XmlTypeElement sType : toSave) {
                    File sFile = FileTools.getFile(sType.getFilepath());
                    if (sFile.compareTo(lFile) != 0) continue;
                    find = true;
                    for (XmlDeviceElement lDev : lType.getDevices()) {
                        if (lDev.getState() != DeviceState.disabled) continue;
                        sType.addDevice(lDev);
                    }
                }
                if (find || lType.getState().compareTo("disabled") != 0) continue;
                toSave.add(lType);
            }
            logger.debug("Configuration compared to the one saved in file.");
        } else {
            file.createNewFile();
        }
    }
}

