/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMPAgent.controller.xmlConfig.saver.unifieders;

import com.veraxsystems.simulatorSNMPAgent.controller.ISimulatorDevice;
import com.veraxsystems.simulatorSNMPAgent.controller.xmlConfig.saver.unifieders.IDeviceUnified;
import com.veraxsystems.simulatorSNMPAgent.controller.xmlConfig.saver.unifieders.PortDeviceUnified;
import java.util.Collection;

public class IpDeviceUnified
extends PortDeviceUnified
implements IDeviceUnified {
    private static final int MASK = 256;
    private static final int PARTS = 4;

    public IpDeviceUnified() {
    }

    public IpDeviceUnified(Collection<ISimulatorDevice> devices) {
        super.generateHash(devices);
    }

    @Override
    protected Object toObject(Long val) {
        StringBuilder str = new StringBuilder();
        long value = val;
        for (int i = 3; i > 0; --i) {
            long curMask = (long)Math.pow(256.0, i);
            str.append(value / curMask);
            str.append('.');
            value %= curMask;
        }
        str.append(value);
        return str.toString();
    }

    @Override
    protected Long toLong(String object) {
        String[] ip = object.split("\\.");
        Long out = 0L;
        for (int i = 3; i >= 0; --i) {
            out = out + Long.parseLong(ip[i]) * (long)Math.pow(256.0, 3 - i);
        }
        return out;
    }

    @Override
    protected String getHashBase(ISimulatorDevice simulatorDevice) {
        return simulatorDevice.getIpAddress();
    }
}

