/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMPAgent.controller.xmlConfig.saver.unifieders;

import com.veraxsystems.simulatorSNMPAgent.controller.ISimulatorDevice;
import com.veraxsystems.simulatorSNMPAgent.controller.xmlConfig.saver.unifieders.IDeviceUnified;
import com.veraxsystems.simulatorSNMPAgent.controller.xmlConfig.saver.unifieders.LongRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class PortDeviceUnified
implements IDeviceUnified {
    private List<LongRange> ranges = new ArrayList<LongRange>();

    public PortDeviceUnified() {
    }

    public PortDeviceUnified(Collection<ISimulatorDevice> devices) {
        this.generateHash(devices);
    }

    @Override
    public final void generateHash(Collection<ISimulatorDevice> devicesCollection) {
        ArrayList<Long> values = new ArrayList<Long>();
        for (ISimulatorDevice dev : devicesCollection) {
            Long val = this.toLong(this.getHashBase(dev));
            if (values.contains(val)) continue;
            values.add(val);
        }
        Collections.sort(values);
        Integer idx = 0;
        Integer key = 0;
        for (int i = 1; i < values.size(); ++i) {
            if ((Long)values.get(i) - (Long)values.get(i - 1) <= 1L) continue;
            this.ranges.add(new LongRange((Long)values.get(idx), key, i - idx + 1));
            key = key + (i - idx + 1);
            idx = i;
        }
        this.ranges.add(new LongRange((Long)values.get(idx), key, values.size() - idx + 1));
    }

    @Override
    public int getHash(Object object) {
        for (LongRange range : this.ranges) {
            if (!range.isValueInRange(this.toLong(object.toString()))) continue;
            return range.getKey(this.toLong(object.toString()));
        }
        return 0;
    }

    @Override
    public Object getObject(int hash) {
        for (LongRange range : this.ranges) {
            if (!range.isKeyInRange(hash)) continue;
            return this.toObject(range.getValue(hash));
        }
        return null;
    }

    @Override
    public int getValuesCount() {
        if (this.ranges.size() > 0) {
            LongRange lastRange = this.ranges.get(this.ranges.size() - 1);
            return lastRange.getStartKey() + lastRange.getCount();
        }
        return -1;
    }

    protected Long toLong(String object) {
        return Long.parseLong(object);
    }

    protected Object toObject(Long val) {
        return val;
    }

    protected String getHashBase(ISimulatorDevice simulatorDevice) {
        return simulatorDevice.getPort();
    }
}

