/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMPAgent.controller.xmlConfig.structure;

import com.veraxsystems.simulatorSNMP.customTypes.IPv4;
import com.veraxsystems.simulatorSNMP.rmi.commands.ExecutionStatus;
import com.veraxsystems.simulatorSNMP.rmi.dto.DeviceDTO;
import com.veraxsystems.simulatorSNMP.rmi.types.DeviceState;
import com.veraxsystems.simulatorSNMP.tools.XMLTools;
import com.veraxsystems.simulatorSNMP.tools.config.SimulatorConfiguration;
import com.veraxsystems.simulatorSNMPAgent.controller.xmlConfig.structure.Pair;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlDeviceElement {
    private static Logger logger = Logger.getLogger(XmlDeviceElement.class);
    private DeviceState state = DeviceState.running;
    private String ip = "127.0.0.1";
    private String port = "161";
    private String netmask = "24";
    private String community = "";
    private String writeCommunity = "";
    private List<String> ips = new ArrayList<String>();

    public XmlDeviceElement() {
    }

    public XmlDeviceElement(String ip, String netmask, String port, DeviceState state, String community, String writeCommunity) {
        this.state = state;
        this.ip = ip;
        this.port = port;
        this.netmask = netmask;
        this.community = community;
        this.writeCommunity = writeCommunity;
        if (community == null) {
            this.community = SimulatorConfiguration.getConfiguration().getEntry("COMMUNITY");
        }
        if (writeCommunity == null) {
            this.writeCommunity = SimulatorConfiguration.getConfiguration().getEntry("WRITE_COMMUNITY");
        }
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getIp() {
        return this.ip;
    }

    public void setNetmask(String netmask) {
        this.netmask = netmask;
    }

    public String getNetmask() {
        return this.netmask;
    }

    public void setState(DeviceState state) {
        this.state = state;
    }

    public DeviceState getState() {
        return this.state;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getPort() {
        return this.port;
    }

    public static XmlDeviceElement parseNode(Node node) {
        if (node.getNodeType() == 1 && node.getNodeName().equals("device")) {
            DeviceState state = null;
            try {
                String stateStr = XMLTools.getParVal("state", node);
                state = stateStr != null && stateStr.length() > 0 ? DeviceState.parseState(stateStr) : DeviceState.running;
            }
            catch (IllegalArgumentException e) {
                logger.error(e.getMessage(), e);
                state = DeviceState.running;
            }
            XmlDeviceElement device = new XmlDeviceElement(XMLTools.getParVal("ip", node), XMLTools.getParVal("netmask", node), XMLTools.getParVal("port", node), state, XMLTools.getParVal("community", node), XMLTools.getParVal("writeCommunity", node));
            NodeList nl = ((Element)node).getElementsByTagName("IP");
            for (int i = 0; i < nl.getLength(); ++i) {
                String iIp = XMLTools.getParVal("ip", nl.item(i));
                String iNetmask = XMLTools.getParVal("ip", nl.item(i));
                if (!(iIp instanceof String) || !(iNetmask instanceof String)) continue;
                device.addIP(iIp + "/" + iNetmask);
            }
            return device;
        }
        return null;
    }

    public static ExecutionStatus processAddresses(String ip, String port, List<Pair<IPv4>> parsedIps, List<Pair<Integer>> parsedPorts) {
        ExecutionStatus result = new ExecutionStatus();
        String[] addresses = ip.split(",");
        for (int z = 0; z < addresses.length; ++z) {
            String[] ports;
            try {
                String[] t = addresses[z].split("-");
                IPv4 ipStart = new IPv4(t[0]);
                IPv4 ipEnd = t.length > 1 ? new IPv4(t[1]) : new IPv4(t[0]);
                parsedIps.add(new Pair<IPv4>(ipStart, ipEnd));
            }
            catch (Exception exp) {
                String msg = exp.getMessage();
                logger.error(msg, exp);
                result.addMessage("address", "invalid.ip.address");
                result.setStatus(20);
                return result;
            }
            for (String portEntity : ports = port.split(",")) {
                try {
                    String[] t = portEntity.split("-");
                    int portStart = Integer.parseInt(t[0]);
                    int portEnd = t.length > 1 ? Integer.parseInt(t[1]) : Integer.parseInt(t[0]);
                    parsedPorts.add(new Pair<Integer>(portStart, portEnd));
                }
                catch (Exception exp) {
                    String msg = "Wrong port format";
                    logger.error(msg, exp);
                    result.addMessage("port", "invalid.port");
                    result.setStatus(20);
                    return result;
                }
            }
        }
        return result;
    }

    public static List<XmlDeviceElement> getSplitDevices(XmlDeviceElement combined) throws MissingArgumentException {
        ArrayList<Pair<IPv4>> parsedIps = new ArrayList<Pair<IPv4>>();
        ArrayList<Pair<Integer>> parsedPorts = new ArrayList<Pair<Integer>>();
        ArrayList<XmlDeviceElement> result = new ArrayList<XmlDeviceElement>();
        XmlDeviceElement.processAddresses(combined.ip, combined.port, parsedIps, parsedPorts);
        for (Pair pair : parsedIps) {
            IPv4 adr = new IPv4(((IPv4)pair.getV1()).toString());
            while (!adr.greaterThan((IPv4)pair.getV2()).booleanValue()) {
                for (Pair pair2 : parsedPorts) {
                    for (int i = ((Integer)pair2.getV1()).intValue(); i <= (Integer)pair2.getV2(); ++i) {
                        result.add(new XmlDeviceElement(adr.toString(), combined.netmask, i + "", combined.state, combined.community, combined.writeCommunity));
                    }
                }
                adr = adr.next();
            }
        }
        return result;
    }

    public void setIPS(List<String> iPS) {
        this.ips = iPS;
    }

    public List<String> getIPS() {
        return this.ips;
    }

    public void addIP(String ip) {
        this.ips.add(ip);
    }

    public String getSortedIP() {
        try {
            return this.splitAndSort(this.ip, IPv4.class.getConstructor(String.class));
        }
        catch (Exception e) {
            return this.port;
        }
    }

    public String getSortedPort() {
        try {
            return this.splitAndSort(this.port, Integer.class.getConstructor(String.class));
        }
        catch (Exception e) {
            return this.port;
        }
    }

    public String getCommunity() {
        return this.community;
    }

    public void setCommunity(String community) {
        this.community = community;
    }

    public String getWriteCommunity() {
        return this.writeCommunity;
    }

    public void setWriteCommunity(String writeCommunity) {
        this.writeCommunity = writeCommunity;
    }

    private <T> String splitAndSort(String source, Constructor<T> constructor) {
        String[] listSplited;
        ArrayList<Pair<T>> toSort = new ArrayList<Pair<T>>();
        for (String string : listSplited = source.split(",")) {
            String[] rangeS = string.split("-");
            try {
                if (rangeS.length > 1) {
                    toSort.add(new Pair<T>(constructor.newInstance(rangeS[0]), constructor.newInstance(rangeS[1])));
                    continue;
                }
                if (rangeS.length <= 0) continue;
                T obj = constructor.newInstance(rangeS[0]);
                toSort.add(new Pair<T>(obj, obj));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Collections.sort(toSort, new Comparator<Pair<T>>(){

            @Override
            public int compare(Pair<T> o1, Pair<T> o2) {
                if (o1.getV1() instanceof IPv4) {
                    int r1 = ((IPv4)o1.getV1()).compareTo((IPv4)o2.getV1());
                    if (r1 != 0) {
                        return r1;
                    }
                    return ((IPv4)o1.getV2()).compareTo((IPv4)o2.getV2());
                }
                if (o1.getV1() instanceof Integer) {
                    int r1 = ((Integer)o1.getV1()).compareTo((Integer)o2.getV1());
                    if (r1 != 0) {
                        return r1;
                    }
                    return ((Integer)o1.getV2()).compareTo((Integer)o2.getV2());
                }
                return 0;
            }
        });
        StringBuilder strBld = new StringBuilder();
        boolean first = true;
        for (Pair pair : toSort) {
            if (!first) {
                strBld.append(',');
            } else {
                first = false;
            }
            if (pair.getV1().equals(pair.getV2())) {
                strBld.append(pair.getV1().toString());
                continue;
            }
            strBld.append(pair.getV1().toString());
            strBld.append('-');
            strBld.append(pair.getV2().toString());
        }
        return strBld.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DeviceDTO) {
            DeviceDTO dto = (DeviceDTO)obj;
            return this.ip.equals(dto.getAddress()) && this.port.equals(dto.getPort());
        }
        return super.equals(obj);
    }
}

