/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMPAgent.controller.xmlConfig.structure;

import com.veraxsystems.simulatorSNMP.tools.FileTools;
import com.veraxsystems.simulatorSNMP.tools.XMLTools;
import com.veraxsystems.simulatorSNMPAgent.controller.xmlConfig.structure.XmlDeviceElement;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlTypeElement {
    private String filepath = "";
    private String state = "";
    private List<XmlDeviceElement> devices = new LinkedList<XmlDeviceElement>();

    public void setFilepath(String filepath) throws IOException {
        this.filepath = FileTools.getFile(filepath).getAbsolutePath();
    }

    public String getFilepath() {
        return this.filepath;
    }

    public void setDevices(List<XmlDeviceElement> devices) {
        this.devices = devices;
    }

    public List<XmlDeviceElement> getDevices() {
        return this.devices;
    }

    public void addDevice(XmlDeviceElement device) {
        this.devices.add(device);
    }

    public void addAllDevices(Collection<XmlDeviceElement> devices) {
        this.devices.addAll(devices);
    }

    public void setState(String state) {
        this.state = state instanceof String ? state : "";
    }

    public String getState() {
        return this.state;
    }

    public static XmlTypeElement parseNode(Node node, boolean loadDevices) throws IOException {
        if (node.getNodeType() == 1 && node.getNodeName().equals("type")) {
            XmlTypeElement type = new XmlTypeElement();
            type.setFilepath(XMLTools.getParVal("filepath", node));
            type.setState(XMLTools.getParVal("state", node));
            if (loadDevices) {
                NodeList nl = ((Element)node).getElementsByTagName("device");
                for (int i = 0; i < nl.getLength(); ++i) {
                    type.addDevice(XmlDeviceElement.parseNode(nl.item(i)));
                }
            }
            return type;
        }
        return null;
    }
}

