/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMPAgent.custom;

import com.veraxsystems.simulatorSNMPAgent.Agent;
import com.veraxsystems.simulatorSNMPAgent.custom.CustomMOScalar;
import com.veraxsystems.simulatorSNMPAgent.model.IOIDModel;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.IValueRandomizer;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.StatefulRandomizer;
import com.veraxsystems.simulatorSNMPAgent.service.IOidDataService;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.PDU;
import org.snmp4j.agent.CommandProcessor;
import org.snmp4j.agent.RequestHandler;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.snmp.CoexistenceInfo;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class CustomCommandProcessor
extends CommandProcessor {
    private Agent agent;
    private Logger logger = Logger.getLogger(CustomCommandProcessor.class);
    private IOidDataService dataService;
    private int repetitions = 1;

    public CustomCommandProcessor(OctetString contextEngineID) {
        super(contextEngineID);
    }

    public void setBaseAgent(Agent agent) {
        this.agent = agent;
    }

    public void setDataService(IOidDataService dataService) {
        this.dataService = dataService;
    }

    private void registerData(OID oidRequest) {
        try {
            IOIDModel model = this.dataService.find(oidRequest.toString(), this.repetitions);
            if (model != null) {
                this.registerScalar(model, true);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    private void registerScalar(IOIDModel model, Boolean next) {
        CustomMOScalar scalar = this.buildCustomMOScalar(model, next);
        IOIDModel subModel = model.getNextOid();
        if (subModel != null) {
            scalar.setScalarAsUpperBound(this.buildCustomMOScalar(subModel, false));
            this.registerScalar(subModel, true);
        }
        this.agent.registerManagedObject(scalar);
    }

    private CustomMOScalar buildCustomMOScalar(IOIDModel model, Boolean next) {
        return new CustomMOScalar(new OID(model.getOid()), MOAccessImpl.ACCESS_READ_WRITE, model.getVariableValue(next));
    }

    private void unregisterData() {
        this.agent.unregisterManagedObject();
    }

    @Override
    protected void processRequest(CommandResponderEvent command, CoexistenceInfo cinfo, RequestHandler handler) {
        PDU pdu = command.getPDU();
        try {
            this.repetitions = pdu.getMaxRepetitions();
        }
        catch (UnsupportedOperationException e) {
            this.repetitions = 0;
        }
        switch (pdu.getType()) {
            case -96: 
            case -95: 
            case -91: {
                Iterator<? extends VariableBinding> iterator = pdu.getVariableBindings().iterator();
                this.unregisterData();
                while (iterator.hasNext()) {
                    String oid = iterator.next().getOid().toString();
                    this.logger.info("Processing OID " + oid);
                    this.registerData(new OID(oid));
                }
                break;
            }
            case -93: {
                for (VariableBinding variableBinding : pdu.getVariableBindings()) {
                    String oid = variableBinding.getOid().toString();
                    Variable value = variableBinding.getVariable();
                    IOIDModel model = this.dataService.find(oid, this.repetitions);
                    String type = model.getParsedType();
                    if (!oid.startsWith(".")) {
                        oid = "." + oid;
                    }
                    this.dataService.setValue(oid, type + ": " + ((Object)value).toString());
                    IValueRandomizer randomizer = model.getRandomizer();
                    if (randomizer instanceof StatefulRandomizer) {
                        ((StatefulRandomizer)((Object)randomizer)).setValue(value);
                    }
                    this.dataService.find(oid.substring(1), this.repetitions).setRandomizer(randomizer);
                }
                break;
            }
        }
        super.processRequest(command, cinfo, handler);
    }
}

