/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMPAgent.dao;

import com.veraxsystems.simulatorSNMP.exceptions.OIDBindingException;
import com.veraxsystems.simulatorSNMP.rmi.commands.ExecutionStatus;
import com.veraxsystems.simulatorSNMP.tools.SNMPTools;
import com.veraxsystems.simulatorSNMPAgent.dao.IOidDataDao;
import com.veraxsystems.simulatorSNMPAgent.model.IOIDModel;
import com.veraxsystems.simulatorSNMPAgent.model.OIDModel;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.ModelValueRand;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.network.simulator.INetworkRecords;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class OidDataDAO
implements IOidDataDao {
    private Logger logger = Logger.getLogger(OidDataDAO.class);
    private List<IOIDModel> dataCache = new ArrayList<IOIDModel>();
    private List<IOIDModel> data = new ArrayList<IOIDModel>();
    private static Map<String, IOIDModel> oidModelCache;
    private int lastIdx = 0;
    private INetworkRecords network = null;

    public OidDataDAO(INetworkRecords netSim) {
        if (oidModelCache == null) {
            oidModelCache = new ConcurrentHashMap<String, IOIDModel>();
        }
        this.network = netSim;
    }

    @Override
    public int dataCount() {
        return this.data.size();
    }

    @Override
    public List<IOIDModel> get(int idx, int count) {
        ArrayList<IOIDModel> checkData = new ArrayList<IOIDModel>();
        checkData.add(this.data.get(idx));
        for (int j = 1; j <= (count != 0 ? count : 1) && idx + j < this.data.size(); ++j) {
            checkData.add(this.data.get(idx + j));
        }
        return checkData;
    }

    @Override
    public List<IOIDModel> getAll() {
        return this.data;
    }

    @Override
    public List<IOIDModel> getCurrentBlock(String oid, int count) {
        if (this.dataCache.size() > 0) {
            for (int i = 0; i < this.dataCache.size(); ++i) {
                if (!this.dataCache.get(i).getOid().equals("." + oid)) continue;
                if (i != 0) break;
                return this.dataCache;
            }
        }
        this.dataCache.clear();
        this.lastIdx = this.searchIdx("." + oid);
        this.dataCache.addAll(this.get(this.lastIdx, count));
        return this.dataCache;
    }

    @Override
    public IOIDModel getSingle(int idx) {
        return idx < this.data.size() ? this.data.get(idx) : null;
    }

    @Override
    public synchronized void loadData(List<String> lines) {
        this.loadData(lines, null);
    }

    public synchronized void loadData(List<String> lines, Map<String, String> errors) {
        this.data.clear();
        this.dataCache.clear();
        this.lastIdx = 0;
        ModelValueRand modelValueRand = new ModelValueRand(this);
        OIDModel tmp = null;
        String t = "";
        this.logger.debug("Data procesing");
        Iterator<String> it = lines.iterator();
        while (it.hasNext()) {
            tmp = null;
            try {
                t = it.next();
                modelValueRand.parseRandomSettings(t);
                t = modelValueRand.getParsedLine();
                if (!oidModelCache.containsKey(t)) {
                    tmp = new OIDModel(t, modelValueRand.getRandomizer());
                    oidModelCache.put(t, tmp);
                } else {
                    tmp = new OIDModel(oidModelCache.get(t), modelValueRand.getRandomizer());
                }
                if (tmp.isError()) {
                    throw new OIDBindingException("Unknown error");
                }
                if (this.data.size() == 0 || SNMPTools.checkOid(tmp.getOid(), this.data.get(this.data.size() - 1).getOid()) > 0) {
                    this.data.add(tmp);
                    continue;
                }
                int idx = this.searchIdx(tmp.getOid());
                if (tmp.getOid().equals(this.data.get(idx).getOid())) continue;
                this.data.add(idx, tmp);
            }
            catch (OIDBindingException e) {
                this.logger.error(e.getMessage() + " Line: " + t, e);
                if (errors == null) continue;
                if (tmp == null || tmp.getOid() == null) {
                    errors.put(t, "oid.not.found");
                    continue;
                }
                errors.put(tmp.getOid(), e.getLabel());
            }
        }
    }

    @Override
    public int searchIdx(String oid) {
        int min = 0;
        int max = this.data.size() - 1;
        while (min != max) {
            int idx = min + (max - min) / 2;
            int i = SNMPTools.checkOid(oid, this.data.get(idx).getOid());
            if (i == 0) {
                return idx;
            }
            if (i < 0) {
                max = idx;
                continue;
            }
            min = idx + 1;
        }
        return min;
    }

    @Override
    public INetworkRecords getNetwork() {
        return this.network;
    }

    @Override
    public void setNetwork(INetworkRecords network) {
        this.network = network;
    }

    @Override
    public ExecutionStatus updateOid(String oid, String newValue) {
        this.dataCache.clear();
        int index = this.searchIdx(oid);
        String line = oid + " = " + newValue;
        ExecutionStatus executionStatus = new ExecutionStatus();
        OIDModel tmp = this.prepareModel(line, executionStatus);
        if (executionStatus.isExecutedCorrectly()) {
            if (this.data.get(index).getOid().equals(oid)) {
                this.data.set(index, tmp);
            } else {
                this.data.add(index, tmp);
            }
        }
        return executionStatus;
    }

    private OIDModel prepareModel(String line, ExecutionStatus executionStatus) {
        ModelValueRand modelValueRand = new ModelValueRand(this);
        modelValueRand.parseRandomSettings(line);
        String parsedLine = modelValueRand.getParsedLine();
        OIDModel tmp = null;
        try {
            tmp = new OIDModel(parsedLine, modelValueRand.getRandomizer());
        }
        catch (OIDBindingException e) {
            executionStatus.addMessage("oid", e.getMessage());
            executionStatus.setStatus(51);
        }
        if (tmp != null && tmp.isError()) {
            executionStatus.addMessage("newValue", "cannot.build.oidmodel");
            executionStatus.setStatus(-1);
        }
        return tmp;
    }

    @Override
    public ExecutionStatus updateOids(List<String> newValues) {
        this.dataCache.clear();
        this.data.clear();
        ExecutionStatus executionStatus = new ExecutionStatus();
        for (String line : newValues) {
            ExecutionStatus tempStatus;
            OIDModel tmp = this.prepareModel(line, tempStatus = new ExecutionStatus());
            if (tmp != null) {
                int index;
                String oid = tmp.getOid();
                int n = index = this.data.size() > 0 ? this.searchIdx(oid) : 0;
                if (this.data.size() == 0 || !this.data.get(index).getOid().equals(oid)) {
                    this.data.add(index, tmp);
                } else {
                    this.data.set(index, tmp);
                }
            }
            if (tempStatus.isExecutedCorrectly() || tempStatus.getStatus() == 51) continue;
            executionStatus.setStatus(tempStatus.getStatus());
            if (tempStatus.getErrors().size() <= 0) continue;
            executionStatus.addMessage(line, tempStatus.getMessage());
        }
        return executionStatus;
    }
}

