/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMPAgent.dao.loader;

import com.veraxsystems.simulatorSNMP.tools.FileTools;
import com.veraxsystems.simulatorSNMPAgent.controller.ISimulatorDevice;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class SnmpFileWatcher
extends Thread {
    private static final int SLEEP_TIME = 2000;
    private Logger logger = Logger.getLogger(SnmpFileWatcher.class);
    private File f;
    private List<String> lines = new ArrayList<String>();
    private List<ISimulatorDevice> registredObservers = new ArrayList<ISimulatorDevice>();
    private long lastModified = 0L;
    private Boolean internalChangeOccured = false;

    public SnmpFileWatcher(String file) throws IOException {
        this.f = FileTools.getFile(file);
        this.loadFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void loadFile() throws IOException {
        this.lines.clear();
        BufferedReader reader = new BufferedReader(new FileReader(this.f));
        String newLine = "";
        String lineInput = "";
        Boolean inString = false;
        try {
            while ((newLine = reader.readLine()) != null) {
                if (newLine.startsWith(".") && !lineInput.isEmpty()) {
                    this.lines.add(lineInput);
                    lineInput = "";
                    inString = newLine.toLowerCase().indexOf("string:") > 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
                }
                lineInput = lineInput + (inString != false ? "\n" : "") + newLine;
            }
            this.lines.add(lineInput);
        }
        finally {
            reader.close();
        }
        this.lastModified = this.f.lastModified();
        this.logger.debug("File loaded! " + this.f.getAbsolutePath());
    }

    public void clear() {
        this.lines.clear();
    }

    public File getFile() {
        return this.f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (true) {
                Boolean bl = this.internalChangeOccured;
                synchronized (bl) {
                    if (this.internalChangeOccured.booleanValue() && this.lastModified != this.f.lastModified()) {
                        this.lastModified = this.f.lastModified();
                        this.internalChangeOccured = false;
                    }
                    if (this.lastModified != this.f.lastModified()) {
                        this.logger.debug("File changed! " + this.f.getAbsolutePath());
                        this.logger.info("Reloading file " + this.f.getPath());
                        try {
                            this.loadFile();
                            for (ISimulatorDevice insCon : this.registredObservers) {
                                insCon.getDataDAO().loadData(new LinkedList<String>(this.lines));
                            }
                            this.lines.clear();
                        }
                        catch (IOException e) {
                            this.logger.error("Can't load snmp records file:" + this.f.getAbsolutePath());
                        }
                    }
                }
                Thread.sleep(2000L);
            }
        }
        catch (InterruptedException e) {
            this.registredObservers.clear();
            return;
        }
    }

    public List<String> getLines() {
        return this.lines;
    }

    public void setLines(List<String> lines) {
        this.lines = lines;
    }

    public synchronized void registerObserver(ISimulatorDevice observer) {
        this.registredObservers.add(observer);
        if (this.lines.size() == 0) {
            try {
                this.loadFile();
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), e);
            }
        }
        observer.getDataDAO().loadData(this.lines);
    }

    public void unregisterObserver(ISimulatorDevice observer) {
        this.registredObservers.remove(observer);
    }

    public void unregisterAllObserver() {
        this.registredObservers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allowChange() {
        Boolean bl = this.internalChangeOccured;
        synchronized (bl) {
            this.internalChangeOccured = true;
        }
    }
}

