/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMPAgent.model;

import com.veraxsystems.simulatorSNMP.exceptions.OIDBindingException;
import com.veraxsystems.simulatorSNMPAgent.model.IOIDModel;
import com.veraxsystems.simulatorSNMPAgent.model.parser.VariableParser;
import com.veraxsystems.simulatorSNMPAgent.model.parser.VariableParserChain;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.IValueRandomizer;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;
import org.snmp4j.smi.Variable;

public class OIDModel
implements IOIDModel {
    private static Logger logger = Logger.getLogger(OIDModel.class);
    private String oid = null;
    private int variableType;
    private String parsedType;
    private Variable variableValue;
    private IOIDModel nextOid;
    private boolean error = false;
    private IValueRandomizer valRand = null;
    private static final String VARIABLE_TYPE_START_PATTERN = " =";
    private static final String VARIABLE_TYPE_STOP_PATTERN = ": ";
    private static final String OID_STOP_PATTERN = " =";
    private static final String VARIABLE_VALUE_START_PATTERN = ": ";
    private static final VariableParserChain PARSER_CHAIN = new VariableParserChain();

    public OIDModel(String stringLine, IValueRandomizer rand) throws OIDBindingException {
        try {
            if (rand != null) {
                this.valRand = rand;
            }
            this.oid = this.getOIDFromLine(stringLine);
            this.prepareVariable(stringLine);
        }
        catch (OIDBindingException e) {
            this.error = true;
            throw e;
        }
        catch (Exception ex) {
            this.error = true;
            throw new OIDBindingException("Item parsing exception: " + ex.getMessage(), ex);
        }
    }

    public OIDModel(IOIDModel oidModel, IValueRandomizer randomizer) {
        if (randomizer != null) {
            this.valRand = randomizer;
        }
        this.oid = oidModel.getOid();
        this.variableType = oidModel.getVariableType();
        this.variableValue = oidModel.getVariableValue(false);
        this.parsedType = oidModel.getParsedType();
    }

    private void prepareVariable(String stringLine) throws OIDBindingException, ParseException {
        this.variableType = -1;
        String testType = "";
        String testValue = "";
        testType = this.getVariableTypeFromLine(stringLine);
        testType = testType.trim().toUpperCase();
        testValue = this.getVariableValueFromLine(stringLine);
        try {
            VariableParser parser = PARSER_CHAIN.getParserForType(testType);
            this.variableType = parser.getSmiType();
            this.parsedType = parser.getParsedType();
            this.variableValue = parser.parseValue(testValue);
        }
        catch (NumberFormatException e) {
            throw new OIDBindingException("Wrong number value format!", "invalid.number.format", e);
        }
    }

    private String getOIDFromLine(String stringLine) throws OIDBindingException {
        String returnValue2;
        try {
            int start = 0;
            int stop = stringLine.indexOf(" =");
            returnValue2 = stringLine.substring(start, stop);
        }
        catch (StringIndexOutOfBoundsException ex) {
            String returnValue2 = "";
            this.error = true;
            throw new OIDBindingException("Oid not found!", "oid.not.found", ex);
        }
        return returnValue2.trim();
    }

    private String getVariableTypeFromLine(String stringLine) throws OIDBindingException {
        String returnValue2;
        try {
            int start = stringLine.indexOf(" =");
            int stop = stringLine.indexOf(": ");
            returnValue2 = stringLine.substring(start + " =".length(), stop);
            returnValue2 = returnValue2.trim();
        }
        catch (StringIndexOutOfBoundsException ex) {
            String returnValue2 = "";
            this.error = true;
            throw new OIDBindingException("Type not found!", "type.not.found", ex);
        }
        return returnValue2.trim();
    }

    private String getVariableValueFromLine(String stringLine) throws OIDBindingException {
        String returnValue2;
        try {
            int start = stringLine.indexOf(": ") + ": ".length();
            int stop = stringLine.length();
            returnValue2 = stringLine.substring(start, stop).trim();
        }
        catch (StringIndexOutOfBoundsException ex) {
            logger.error(ex.getMessage(), ex);
            String returnValue2 = "";
            this.error = true;
            throw new OIDBindingException("Value not found!", "value.not.found", ex);
        }
        if (returnValue2 == null) {
            returnValue2 = "";
        }
        return returnValue2;
    }

    @Override
    public String getOid() {
        return this.oid;
    }

    @Override
    public int getVariableType() {
        return this.variableType;
    }

    @Override
    public String getParsedType() {
        return this.parsedType;
    }

    @Override
    public Variable getVariableValue(Boolean next) {
        if (this.valRand != null && next.booleanValue()) {
            this.setVariableValue(this.valRand.nextValue(this.variableValue));
        }
        return this.variableValue;
    }

    public void setVariableValue(Variable variableValue) {
        this.variableValue = variableValue;
    }

    @Override
    public void setNextOid(IOIDModel nextOid) {
        this.nextOid = nextOid;
    }

    @Override
    public IOIDModel getNextOid() {
        return this.nextOid;
    }

    @Override
    public void setOid(String oid) {
        this.oid = oid;
    }

    public String toString() {
        return "Oid: " + this.getOid() + " Type: " + this.getVariableType() + " Value: " + this.getVariableValue(false);
    }

    @Override
    public boolean isError() {
        return this.error;
    }

    @Override
    public void setRandomizer(IValueRandomizer randomizer) {
        this.valRand = randomizer;
    }

    @Override
    public IValueRandomizer getRandomizer() {
        return this.valRand;
    }
}

