/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMPAgent.model.randomizer;

import com.veraxsystems.simulatorSNMP.exceptions.VRArgsException;
import com.veraxsystems.simulatorSNMPAgent.dao.IOidDataDao;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.IValueRandomizer;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.factory.ValueRandomizerFactory;
import org.apache.log4j.Logger;

public class ModelValueRand
implements Cloneable {
    private Logger logger = Logger.getLogger(ModelValueRand.class);
    private boolean randomable = false;
    private String settings = "";
    private String[] args;
    private String parsedLine = "";
    private static final String PRERAND_PREFIX = "//^";
    private static final String PRERAND_POSTFIX = "^//";
    private static final String POSTRAND_PREFIX = "//$";
    private ValueRandomizerFactory factory;

    public ModelValueRand(IOidDataDao parent) {
        this.factory = new ValueRandomizerFactory(parent);
    }

    public String parseRandomSettings(String line) {
        int staticStart = 0;
        int staticEnd = 0;
        String out = "";
        String processed = line;
        if (processed != null && !processed.isEmpty()) {
            while (true) {
                staticStart = processed.indexOf(PRERAND_PREFIX);
                staticEnd = processed.indexOf(PRERAND_POSTFIX);
                if (staticStart < 0 || staticEnd < 0 || staticStart >= staticEnd) break;
                out = processed.substring(0, staticStart);
                String opt = processed.substring(staticStart + PRERAND_PREFIX.length(), staticEnd).trim();
                String type = opt.substring(0, opt.indexOf(40)).toLowerCase().trim();
                String args1 = opt.substring(opt.indexOf(40) + 1, opt.lastIndexOf(41));
                try {
                    out = this.parseStaticArguments(out, type, args1);
                }
                catch (VRArgsException e) {
                    this.logger.error("Error parsing prerandomizer directives: " + e.getMessage() + ". In line:" + processed);
                }
                processed = out = out + processed.substring(staticEnd + PRERAND_POSTFIX.length(), processed.length());
            }
            this.processDynamicRandomizers(processed);
        }
        return this.parsedLine;
    }

    private String parseStaticArguments(String out, String type, String args) throws VRArgsException {
        String result = out;
        result = result + this.factory.createStaticValue(type, args);
        return result;
    }

    private void processDynamicRandomizers(String processed) {
        this.randomable = false;
        this.settings = "";
        this.args = null;
        int startPos = processed.lastIndexOf(POSTRAND_PREFIX);
        if (startPos > 0) {
            String parseValue = processed.substring(startPos + POSTRAND_PREFIX.length());
            this.settings = parseValue.substring(0, parseValue.indexOf(40)).toLowerCase();
            parseValue = parseValue.substring(parseValue.indexOf(40) + 1, parseValue.lastIndexOf(41));
            this.args = parseValue.split(",");
            if (this.selectRnd(this.settings, this.args) != null) {
                this.randomable = true;
            } else {
                this.logger.error("Randomizer error occured in line: " + processed);
            }
        }
        this.parsedLine = startPos >= 0 ? processed.substring(0, startPos) : processed;
    }

    public IValueRandomizer getRandomizer() {
        return this.randomable ? this.selectRnd(this.settings, this.args) : null;
    }

    private IValueRandomizer selectRnd(String randomizerType, String[] args) {
        IValueRandomizer rnd = null;
        try {
            rnd = this.factory.createRandomizer(randomizerType, args);
        }
        catch (VRArgsException exp) {
            this.logger.error("Invalid randomizer arguments: " + exp.getMessage());
            return null;
        }
        return rnd;
    }

    public boolean isRandom() {
        return this.randomable;
    }

    public String getParsedLine() {
        return this.parsedLine;
    }
}

