/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMPAgent.model.randomizer.factory;

import com.veraxsystems.simulatorSNMP.exceptions.VRArgsException;
import com.veraxsystems.simulatorSNMPAgent.dao.IOidDataDao;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.IValueRandomizer;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.factory.RandomizerProducer;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.factory.StaticRandomizerProducer;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.factory.counter.Counter32ValueRandExpFactory;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.factory.counter.Counter32ValueRandFactory;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.factory.counter.Counter32ValueRandInTimeExpFactory;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.factory.counter.Counter32ValueRandInTimeFactory;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.factory.counter.Counter64ValueRandFactory;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.factory.counter.Counter64ValueRandInTimeFactory;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.factory.integer.IntUniqueValueFactory;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.factory.integer.IntValueOprFactory;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.factory.integer.IntValueRandFactory;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.factory.integer.IntValueStepRandFactory;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.factory.integer.IntValueStepRandInTimeFactory;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.factory.other.Gauge32ValueRandFactory;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.factory.other.Gauge32ValueRandInTimeFactory;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.factory.other.HexValueRandFactory;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.factory.other.IpaValueAgentFactory;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.factory.other.IpaValueRandFactory;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.factory.other.MacValueRandFactory;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.factory.other.NetMaskValueFactory;
import java.util.HashMap;
import java.util.Map;

public class ValueRandomizerFactory {
    private Map<String, RandomizerProducer> producers = new HashMap<String, RandomizerProducer>();
    private Map<String, StaticRandomizerProducer> staticProducers;

    public ValueRandomizerFactory(IOidDataDao storage) {
        this.producers.put("int.rnd", new IntValueStepRandFactory());
        this.producers.put("int.stp", new IntValueStepRandFactory());
        this.producers.put("int.tmr", new IntValueStepRandInTimeFactory());
        this.producers.put("hex.rnd", new HexValueRandFactory());
        this.producers.put("c32.rnd", new Counter32ValueRandFactory());
        this.producers.put("c64.rnd", new Counter64ValueRandFactory());
        this.producers.put("ipa.rnd", new IpaValueRandFactory());
        this.producers.put("mac.rnd", new MacValueRandFactory());
        this.producers.put("int.opr", new IntValueOprFactory(storage));
        this.producers.put("c32.tmr", new Counter32ValueRandInTimeFactory());
        this.producers.put("c32.rde", new Counter32ValueRandExpFactory());
        this.producers.put("c32.tme", new Counter32ValueRandInTimeExpFactory());
        this.producers.put("c64.tmr", new Counter64ValueRandInTimeFactory());
        this.producers.put("g32.rnd", new Gauge32ValueRandFactory());
        this.producers.put("g32.tmr", new Gauge32ValueRandInTimeFactory());
        this.staticProducers = new HashMap<String, StaticRandomizerProducer>();
        this.staticProducers.put("mac.rnd", new MacValueRandFactory());
        this.staticProducers.put("int.rnd", new IntValueRandFactory());
        this.staticProducers.put("int.unq", new IntUniqueValueFactory());
        this.staticProducers.put("ipa.adr", new IpaValueAgentFactory(storage.getNetwork()));
        this.staticProducers.put("ipa.net", new NetMaskValueFactory(storage.getNetwork()));
    }

    public IValueRandomizer createRandomizer(String randomizerType, String[] args) throws VRArgsException {
        RandomizerProducer producer = this.producers.get(randomizerType);
        IValueRandomizer randomizer = null;
        if (producer != null) {
            randomizer = producer.getRandomizer(args);
        }
        return randomizer;
    }

    public String createStaticValue(String randomizerType, String args) throws VRArgsException {
        StaticRandomizerProducer producer = this.staticProducers.get(randomizerType);
        String result = "";
        if (producer != null) {
            try {
                result = producer.parseArguments(args);
            }
            catch (NumberFormatException e) {
                throw new VRArgsException("Invalid modifier argument", e);
            }
        }
        return result;
    }
}

