/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMPAgent.model.randomizer.network.simulator;

import com.veraxsystems.simulatorSNMP.tools.FileTools;
import com.veraxsystems.simulatorSNMP.tools.XMLTools;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class NetworkConfigLoader {
    public static final char PORT_SIGN = ':';
    public static final char NET_MASK_SIGN = '/';
    public static final int IP_SPLITTERS = 3;
    public static final int IP_PARTS = 4;
    public static final String NET_CONF_PATH = "network.conf.xml";
    private static Logger logger = Logger.getLogger(NetworkConfigLoader.class);
    private static NetworkConfigLoader instance;
    private Map<String, List<String>> lists = new HashMap<String, List<String>>();

    public static synchronized NetworkConfigLoader getInstance() {
        if (!(instance instanceof NetworkConfigLoader)) {
            instance = new NetworkConfigLoader();
            logger.info("Creating NCL instance");
        }
        logger.debug("Return NCL instance");
        return instance;
    }

    private NetworkConfigLoader() {
        try {
            logger.debug("Loading interfaces data.");
            File confFile = FileTools.getFile(NET_CONF_PATH);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(confFile);
            doc.getDocumentElement().normalize();
            NodeList nl = doc.getElementsByTagName("group");
            for (int i = 0; i < nl.getLength(); ++i) {
                Node net = nl.item(i);
                String key = XMLTools.getParVal("key", net);
                if (this.lists.containsKey(key)) continue;
                NodeList ips = ((Element)net).getElementsByTagName("ip");
                ArrayList<String> ipList = new ArrayList<String>();
                for (int j = 0; j < ips.getLength(); ++j) {
                    ipList.add(ips.item(j).getTextContent());
                }
                this.lists.put(key, ipList);
            }
        }
        catch (IOException e) {
            logger.error("IO error: " + e.getMessage());
        }
        catch (SAXException e) {
            logger.error("Parsing exception: " + e.getMessage());
        }
        catch (ParserConfigurationException e) {
            logger.error("Parser configuration problem: " + e.getMessage());
        }
    }

    public List<String> getIPS(String key) {
        logger.debug("IP Modifier for key:" + key);
        if (this.lists.containsKey(key)) {
            return this.lists.get(key);
        }
        return new ArrayList<String>();
    }

    public List<String> getIPSPermutated(String ip, String port) throws MissingArgumentException {
        ArrayList<String> res = new ArrayList<String>();
        String[] ips = ip.split("\\.");
        res.addAll(this.fromIdx(this.getIPS(ip + ':' + port), res.size()));
        res.addAll(this.fromIdx(this.getIPS(ip + ':' + '*'), res.size()));
        for (int i = 3; i >= 0; --i) {
            for (int j = 3 - i; j >= 0; --j) {
                StringBuilder bld = new StringBuilder();
                for (int pr = 0; pr < i; ++pr) {
                    bld.append(ips[pr]);
                    bld.append('.');
                }
                bld.append('*');
                for (int pt = 4 - j; pt < 4; ++pt) {
                    bld.append('.');
                    bld.append(ips[pt]);
                }
                for (int iPort = 0; iPort < 2; ++iPort) {
                    res.addAll(this.fromIdx(this.getIPS(bld.toString() + ':' + (iPort < 1 ? port : "*")), res.size()));
                }
            }
        }
        return res;
    }

    private List<String> fromIdx(List<String> collection, int startIdx) {
        ArrayList<String> res = new ArrayList<String>();
        try {
            if (startIdx < collection.size()) {
                res.addAll(collection.subList(startIdx, collection.size()));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        return res;
    }
}

