/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMPAgent.model.randomizer.network.simulator;

import com.veraxsystems.simulatorSNMP.customTypes.IPv4;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.network.simulator.INetworkRecords;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.snmp4j.smi.IpAddress;

public class NetworkRecords
implements INetworkRecords {
    private static final int NETMASK_PARTS = 4;
    private static final int NETMASK_LENGTH = 32;
    private static final int NETMASK_PART_LENGTH = 8;
    private Logger logger = Logger.getLogger(NetworkRecords.class);
    private int ipCount = 0;
    private List<IpAddress> ips = new ArrayList<IpAddress>();

    public NetworkRecords(String agentNet) {
        this.addIP(agentNet);
    }

    @Override
    public final void addIP(String data) {
        String[] t = data.split("/");
        try {
            if (t.length < 2) {
                throw new IllegalArgumentException("Expecting: ip_addr/net_mask\n");
            }
            IPv4 address = new IPv4(t[0]);
            String[] netmask = t[1].split("\\.");
            if (netmask.length != 4) {
                int i;
                int net = Integer.parseInt(t[1]);
                int[] adr = new int[]{0, 0, 0, 0};
                for (i = 0; i < 32; ++i) {
                    int n = i / 8;
                    adr[n] = adr[n] << 1;
                    if (net-- <= 0) continue;
                    int n2 = i / 8;
                    adr[n2] = adr[n2] | 1;
                }
                t[1] = "";
                for (i = 0; i < 4; ++i) {
                    t[1] = t[1] + (i > 0 ? "." : "") + Integer.toString(adr[i]);
                }
            }
            this.ips.add(new IpAddress(address.toString()));
            this.ips.add(new IpAddress(t[1]));
            ++this.ipCount;
            this.logger.debug("IP Addres :" + address.toString() + ", was added.");
        }
        catch (Exception exp) {
            this.logger.error(exp.getMessage(), exp);
        }
    }

    @Override
    public void rmIP(String ip) {
        for (int i = 1; i < this.ipCount; ++i) {
            if (!this.ips.get(i * 2).toString().startsWith(ip)) continue;
            this.ips.remove(2 * i + 1);
            this.ips.remove(2 * i);
            --this.ipCount;
            this.logger.debug("Addres " + ip + " was removed.");
        }
    }

    @Override
    public String getIPList() {
        String t = "";
        for (int i = 0; i < this.ipCount; ++i) {
            t = t + (i > 0 ? ", " : "") + this.getIP(i).toString() + "/" + this.getMask(i).toString();
        }
        return t;
    }

    @Override
    public void detail() {
        this.logger.debug("ID\tIP\tNet Mask");
        for (int i = 0; i < this.ipCount; ++i) {
            this.logger.debug(i + "\t" + this.ips.get(2 * i) + "\t" + this.ips.get(2 * i + 1));
        }
    }

    @Override
    public IpAddress getMask(int i) {
        if (i >= 0 && i < this.ipCount) {
            return this.ips.get(2 * i + 1);
        }
        return this.ips.get(1);
    }

    @Override
    public IpAddress getIP(int i) {
        if (i >= 0 && i < this.ipCount) {
            return this.ips.get(2 * i);
        }
        return this.ips.get(0);
    }

    @Override
    public int getIpCount() {
        return this.ipCount;
    }
}

