/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMPAgent.model.randomizer.type.counter;

import com.veraxsystems.simulatorSNMP.exceptions.VRArgsException;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.IValueRandomizer;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.Variable;

public class Counter32ValueRandExp
implements IValueRandomizer {
    private static final int ARG_COUNT = 7;
    private static final int DIRECTION_INDEX = 0;
    private static final int MIN_STEPS_INDEX = 1;
    private static final int MAX_STEPS_INDEX = 2;
    private static final int MIN_DELTA_INDEX = 3;
    private static final int MAX_DELTA_INDEX = 4;
    private static final int MIN_FINAL_INDEX = 5;
    private static final int MAX_FINAL_INDEX = 6;
    private long direction;
    private long minSteps;
    private long maxSteps;
    private long minDelta;
    private long maxDelta;
    private long minFinal;
    private long maxFinal;
    private long steps = 0L;
    private long step = 0L;
    private long add = 0L;
    private static final double XMULTIPLY = 0.3;
    private static final double YMULTIPLY = 1.26E-13;
    private static final double NOISE_STRENGTH = 0.1;
    private static final int BASE = 100;

    public Counter32ValueRandExp(String[] args) throws VRArgsException {
        try {
            if (args.length < 7) {
                throw new Exception("Arguments expected: 7, got: " + args.length);
            }
            this.direction = Long.parseLong(args[0]);
            this.minSteps = Long.parseLong(args[1]);
            this.maxSteps = Long.parseLong(args[2]);
            this.minDelta = Long.parseLong(args[3]);
            this.maxDelta = Long.parseLong(args[4]);
            this.minFinal = Long.parseLong(args[5]);
            this.maxFinal = Long.parseLong(args[6]);
            this.checkMin();
        }
        catch (Exception exp) {
            throw new VRArgsException(exp.getMessage(), exp);
        }
    }

    @Override
    public Variable nextValue(Variable value) {
        if (this.step < 0L) {
            this.step = this.steps = this.minSteps + (long)GENERATOR.nextInt((int)(1L + this.maxSteps - this.minSteps));
            long diffrenceAdd = 1L + this.maxDelta - this.minDelta;
            this.add = Math.round(((double)this.minDelta + (Math.exp((double)GENERATOR.nextInt(100) * 0.3) - 1.0) * 1.26E-13 * (double)diffrenceAdd) * (double)this.direction);
        }
        long newValue = value.toLong() + Math.round((double)this.add * (1.0 + 0.1 * (2.0 * GENERATOR.nextGaussian() - 1.0)));
        --this.step;
        if (newValue > this.maxFinal) {
            newValue = this.minFinal;
        }
        if (newValue < this.minFinal) {
            newValue = this.maxFinal;
        }
        return new Counter32(newValue);
    }

    private void checkMin() throws VRArgsException {
        if (this.minSteps < 0L) {
            this.minSteps = Math.abs(this.minSteps);
        }
        if (this.maxSteps < 0L) {
            this.maxSteps = Math.abs(this.maxSteps);
        }
        if (this.minSteps > this.maxSteps || this.minDelta > this.maxDelta || this.minFinal > this.maxFinal) {
            throw new VRArgsException("Minimum cannot be greater than maximum");
        }
    }
}

