/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMPAgent.model.randomizer.type.counter;

import com.veraxsystems.simulatorSNMP.exceptions.VRArgsException;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.IValueRandomizer;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.type.counter.Counter32ValueRand;
import org.snmp4j.smi.Variable;

public class Counter32ValueRandInTime
extends Counter32ValueRand
implements IValueRandomizer {
    private static final int ARG_COUNT = 8;
    private static final int INTERVAL_INDEX = 7;
    private static final int BASE_INTERVAL = 1000;
    private long lastChange = 0L;
    private long interval = 1000L;

    public Counter32ValueRandInTime(String[] args) throws VRArgsException {
        super(args);
        if (args.length >= 8) {
            this.interval = Long.parseLong(args[7]);
        }
        this.lastChange = System.currentTimeMillis();
    }

    @Override
    public Variable nextValue(Variable value) {
        Variable result = value;
        long count = (System.currentTimeMillis() - this.lastChange) / this.interval;
        if (count > 0L) {
            int i = 0;
            while ((long)i < count) {
                result = super.nextValue(result);
                ++i;
            }
            this.lastChange = System.currentTimeMillis();
        }
        return result;
    }
}

