/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMPAgent.model.randomizer.type.counter;

import com.veraxsystems.simulatorSNMP.exceptions.VRArgsException;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.IValueRandomizer;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.StatefulRandomizer;
import org.apache.log4j.Logger;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Variable;

public class Counter64ValueRand
implements IValueRandomizer,
StatefulRandomizer {
    private static final int ARG_COUNT = 7;
    private static final int DIRECTION_INDEX = 0;
    private static final int MIN_STEPS_INDEX = 1;
    private static final int MAX_STEPS_INDEX = 2;
    private static final int MIN_DELTA_INDEX = 3;
    private static final int MAX_DELTA_INDEX = 4;
    private static final int MIN_FINAL_INDEX = 5;
    private static final int MAX_FINAL_INDEX = 6;
    private static Logger logger = Logger.getLogger(Counter64ValueRand.class);
    private Counter64 lastValue;
    private long direction;
    private long minSteps;
    private long maxSteps;
    private long minDelta;
    private long maxDelta;
    private long minFinal;
    private long maxFinal;
    private int steps = 0;
    private int step = 0;
    private long add = 0L;

    public Counter64ValueRand(String[] args) throws VRArgsException {
        try {
            logger.info("Initializing C64 randomizer");
            if (args.length < 7) {
                throw new Exception("Arguments expected: 7, got: " + args.length);
            }
            this.direction = Long.parseLong(args[0]);
            this.minSteps = Long.parseLong(args[1]);
            this.maxSteps = Long.parseLong(args[2]);
            this.minDelta = Long.parseLong(args[3]);
            this.maxDelta = Long.parseLong(args[4]);
            this.minFinal = Long.parseLong(args[5]);
            this.maxFinal = Long.parseLong(args[6]);
            this.checkMin();
            logger.info("C64 randomizer initialized");
        }
        catch (Exception exp) {
            throw new VRArgsException(exp.getMessage(), exp);
        }
    }

    @Override
    public Variable nextValue(Variable value) {
        if (this.lastValue == null) {
            this.lastValue = new Counter64(Long.parseLong(((Object)value).toString()));
        }
        if (this.step < 0) {
            logger.info("Genereting new random step value and count of steps");
            this.step = this.steps = (int)this.minSteps + GENERATOR.nextInt(1 + (int)this.maxSteps - (int)this.minSteps);
            long diffrenceAdd = 1L + this.maxDelta - this.minDelta;
            this.add = (this.minDelta + (long)Math.abs(GENERATOR.nextInt()) % diffrenceAdd) * this.direction;
        }
        long newValue = this.lastValue.getValue() + this.add;
        --this.step;
        if (newValue > this.maxFinal) {
            newValue = this.minFinal;
        }
        if (newValue < this.minFinal) {
            newValue = this.maxFinal;
        }
        logger.info("New value: " + newValue);
        this.lastValue = new Counter64(newValue);
        return this.lastValue;
    }

    private void checkMin() throws VRArgsException {
        if (this.minSteps < 0L) {
            this.minSteps = Math.abs(this.minSteps);
        }
        if (this.maxSteps < 0L) {
            this.maxSteps = Math.abs(this.maxSteps);
        }
        if (this.minSteps > this.maxSteps || this.minDelta > this.maxDelta || this.minFinal > this.maxFinal) {
            throw new VRArgsException("Minimum cannot be greater than maximum");
        }
    }

    @Override
    public void setValue(Variable v) {
        this.lastValue = new Counter64(v.toLong());
    }
}

