/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMPAgent.model.randomizer.type.integer;

import com.veraxsystems.simulatorSNMP.exceptions.VRArgsException;
import com.veraxsystems.simulatorSNMPAgent.dao.IOidDataDao;
import com.veraxsystems.simulatorSNMPAgent.model.IOIDModel;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.IValueRandomizer;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.StatefulRandomizer;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.Variable;

public class IntValueOpr
implements IValueRandomizer,
StatefulRandomizer {
    private static final int ARG_COUNT = 3;
    private static final int OPERAND1_INDEX = 0;
    private static final int OPERAND2_INDEX = 2;
    private static final int OPERATOR_INDEX = 1;
    private static final int OFFSET = 4;
    private Integer32 lastValue;
    private char opr;
    private Boolean err = false;
    private IOidDataDao storage;
    private OperSide[] values = new OperSide[2];

    public IntValueOpr(String[] args, IOidDataDao str) throws VRArgsException {
        if (args.length < 3) {
            throw new VRArgsException("Int-randomizer: Too small arguments.");
        }
        this.opr = args[1].charAt(0);
        this.values[0] = new OperSide(args[0]);
        this.values[1] = new OperSide(args[2]);
        this.storage = str;
    }

    @Override
    public Variable nextValue(Variable value) {
        if (this.lastValue == null) {
            this.lastValue = new Integer32(Integer.parseInt(((Object)value).toString()));
        }
        if (!this.err.booleanValue()) {
            try {
                switch (this.opr) {
                    case '+': {
                        return new Integer32(this.values[0].getVal() + this.values[1].getVal());
                    }
                    case '-': {
                        return new Integer32(this.values[0].getVal() - this.values[1].getVal());
                    }
                    case '/': {
                        return new Integer32(this.values[0].getVal() / this.values[1].getVal());
                    }
                    case '*': {
                        return new Integer32(this.values[0].getVal() * this.values[1].getVal());
                    }
                }
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
            this.lastValue.setValue(value.toInt());
            return this.lastValue;
        }
        return this.lastValue;
    }

    @Override
    public void setValue(Variable v) {
        this.lastValue = new Integer32(v.toInt());
    }

    public void setDaoStorage(IOidDataDao str) {
        this.storage = str;
    }

    private class OperSide {
        private int number = 1;
        private IOIDModel obj = null;
        private String oid;

        public OperSide(String value) {
            if (value.startsWith("oid(")) {
                this.oid = value.substring(value.indexOf("oid(") + 4, value.length() - 1);
            } else {
                this.number = Integer.parseInt(value.trim());
            }
        }

        public int getVal() {
            if (this.oid != null) {
                if (this.obj == null) {
                    this.obj = IntValueOpr.this.storage.getSingle(IntValueOpr.this.storage.searchIdx(this.oid));
                    if (!this.obj.getOid().equalsIgnoreCase(this.oid)) {
                        IntValueOpr.this.err = true;
                        this.obj = null;
                    }
                }
                return this.obj.getVariableValue(false).toInt();
            }
            return this.number;
        }
    }
}

