/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMPAgent.model.randomizer.type.integer;

import com.veraxsystems.simulatorSNMP.exceptions.VRArgsException;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.IValueRandomizer;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.StatefulRandomizer;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.Variable;

public class IntValueRand
implements IValueRandomizer,
StatefulRandomizer {
    private static final int ARG_COUNT = 1;
    private static final int OPTIONAL_ARG_COUNT = 2;
    private static final int MAX_STEP_INDEX = 0;
    private static final int MIN_VALUE_INDEX = 1;
    private static final int MAX_VALUE_INDEX = 2;
    private int maxStep;
    private int minValue;
    private int maxValue;
    private boolean boundariesSet = false;
    private Integer32 lastValue;
    private Byte direct = 0;

    public IntValueRand(String[] args) throws VRArgsException {
        try {
            if (args.length < 1) {
                throw new VRArgsException("Arguments expected: 1, got: " + args.length);
            }
            this.maxStep = Integer.parseInt(args[0]);
            if (args.length > 3) {
                this.minValue = Integer.parseInt(args[1]);
                this.maxValue = Integer.parseInt(args[2]);
                this.boundariesSet = true;
                if (this.minValue > this.maxValue) {
                    throw new VRArgsException("Minimum cannot be greater than maximum");
                }
            }
        }
        catch (Exception exp) {
            throw new VRArgsException(exp.getMessage(), exp);
        }
    }

    @Override
    public Variable nextValue(Variable value) {
        if (this.lastValue == null) {
            this.lastValue = new Integer32(Integer.parseInt(((Object)value).toString()));
        }
        int add = this.direct == 0 ? GENERATOR.nextInt(this.maxStep * 2) - this.maxStep : GENERATOR.nextInt(this.maxStep);
        int newValue = this.lastValue.getValue() + add;
        if (this.boundariesSet && newValue < this.minValue) {
            newValue = this.maxValue;
        }
        if (this.boundariesSet && newValue > this.maxValue) {
            newValue = this.minValue;
        }
        this.lastValue = new Integer32(newValue);
        return this.lastValue;
    }

    @Override
    public void setValue(Variable v) {
        this.lastValue = new Integer32(v.toInt());
    }
}

