/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMPAgent.model.randomizer.type.integer;

import com.veraxsystems.simulatorSNMP.exceptions.VRArgsException;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.IValueRandomizer;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.StatefulRandomizer;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.Variable;

public class IntValueStepRand
implements IValueRandomizer,
StatefulRandomizer {
    private static final int ARG_COUNT = 7;
    private static final int DIRECTION_INDEX = 0;
    private static final int MIN_STEPS_INDEX = 1;
    private static final int MAX_STEPS_INDEX = 2;
    private static final int MIN_DELTA_INDEX = 3;
    private static final int MAX_DELTA_INDEX = 4;
    private static final int MIN_FINAL_INDEX = 5;
    private static final int MAX_FINAL_INDEX = 6;
    private int direction;
    private int minSteps;
    private int maxSteps;
    private int minDelta;
    private int maxDelta;
    private int minFinal;
    private int maxFinal;
    private Integer32 lastValue;
    private int steps = 0;
    private int step = 0;
    private int add = 0;

    public IntValueStepRand(String[] args) throws VRArgsException {
        try {
            if (args.length < 7) {
                throw new Exception("Arguments expected: 7, got: " + args.length);
            }
            this.direction = Integer.parseInt(args[0]);
            this.minSteps = Integer.parseInt(args[1]);
            this.maxSteps = Integer.parseInt(args[2]);
            this.minDelta = Integer.parseInt(args[3]);
            this.maxDelta = Integer.parseInt(args[4]);
            this.minFinal = Integer.parseInt(args[5]);
            this.maxFinal = Integer.parseInt(args[6]);
            this.checkMin();
        }
        catch (Exception exp) {
            throw new VRArgsException(exp.getMessage(), exp);
        }
    }

    @Override
    public Variable nextValue(Variable value) {
        if (this.lastValue == null) {
            this.lastValue = new Integer32(Integer.parseInt(((Object)value).toString()));
        }
        if (this.step < 0) {
            this.step = this.steps = this.minSteps + GENERATOR.nextInt(1 + this.maxSteps - this.minSteps);
            this.add = this.direction == 0 ? (this.minDelta + GENERATOR.nextInt(1 + this.maxDelta - this.minDelta)) * (GENERATOR.nextBoolean() ? 1 : -1) : (this.minDelta + GENERATOR.nextInt(1 + this.maxDelta - this.minDelta)) * this.direction;
        }
        int newValue = this.lastValue.getValue() + this.add;
        --this.step;
        if (newValue > this.maxFinal) {
            newValue = this.minFinal;
        }
        if (newValue < this.minFinal) {
            newValue = this.maxFinal;
        }
        this.lastValue = new Integer32(newValue);
        return this.lastValue;
    }

    private void checkMin() throws VRArgsException {
        if (this.minSteps < 0) {
            this.minSteps = Math.abs(this.minSteps);
        }
        if (this.maxSteps < 0) {
            this.maxSteps = Math.abs(this.maxSteps);
        }
        if (this.minSteps > this.maxSteps || this.minDelta > this.maxDelta || this.minFinal > this.maxFinal) {
            throw new VRArgsException("Minimum cannot be greater than maximum");
        }
    }

    @Override
    public void setValue(Variable v) {
        this.lastValue = new Integer32(v.toInt());
    }
}

