/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMPAgent.model.randomizer.type.other;

import com.veraxsystems.simulatorSNMP.exceptions.VRArgsException;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.IValueRandomizer;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.StatefulRandomizer;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.Variable;

public class IpaValueRand
implements IValueRandomizer,
StatefulRandomizer {
    private static final int ARG_COUNT = 4;
    private static final int PREFIX_INDEX = 0;
    private static final int SEPARATOR_INDEX = 1;
    private static final int COUNT_INDEX = 2;
    private static final int GENERATION_INDEX = 3;
    private static final int MAX_OCTET = 256;
    private String prefix;
    private String separator;
    private int count;
    private boolean generateNew;
    private IpAddress lastValue;

    public IpaValueRand(String[] args) throws VRArgsException {
        try {
            if (args.length < 4) {
                throw new VRArgsException("Arguments expected: 4, got: " + args.length);
            }
            this.prefix = args[0];
            this.separator = args[1];
            this.count = Integer.parseInt(args[2]);
            this.generateNew = args[3].equalsIgnoreCase("1");
            this.next();
        }
        catch (Exception exp) {
            throw new VRArgsException(exp.getMessage(), exp);
        }
    }

    @Override
    public Variable nextValue(Variable value) {
        if (this.generateNew) {
            this.next();
        }
        return this.lastValue;
    }

    private void next() {
        String t = this.prefix;
        for (int i = 0; i < this.count; ++i) {
            t = t + (i > 0 ? this.separator : "");
            t = t + Integer.toString(GENERATOR.nextInt(256));
        }
        this.lastValue = new IpAddress(t);
    }

    @Override
    public void setValue(Variable v) {
        this.lastValue = new IpAddress(((Object)v).toString());
    }
}

