/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.simulatorSNMPAgent.model.randomizer.type.other;

import com.veraxsystems.simulatorSNMP.exceptions.VRArgsException;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.IValueRandomizer;
import com.veraxsystems.simulatorSNMPAgent.model.randomizer.StatefulRandomizer;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class MacValueRand
implements IValueRandomizer,
StatefulRandomizer {
    private static final int MAX_DIGIT = 16;
    private static final int MAX_PART = 256;
    private static final int ARG_COUNT = 4;
    private static final int PREFIX_INDEX = 0;
    private static final int SEPARATOR_INDEX = 1;
    private static final int COUNT_INDEX = 2;
    private static final int GENERATION_INDEX = 3;
    private String prefix;
    private String separator;
    private int count;
    private boolean generateNew;
    private OctetString lastValue;

    public MacValueRand(String[] args) throws VRArgsException {
        try {
            if (args.length < 4) {
                throw new VRArgsException("Arguments expected: 4, got: " + args.length);
            }
            this.prefix = args[0];
            this.separator = args[1];
            this.count = Integer.parseInt(args[2]);
            this.generateNew = args[3].equalsIgnoreCase("1");
            this.next();
        }
        catch (Exception exp) {
            throw new VRArgsException(exp.getMessage(), exp);
        }
    }

    @Override
    public Variable nextValue(Variable value) {
        if (this.generateNew) {
            this.next();
        }
        return this.lastValue;
    }

    private void next() {
        StringBuilder sbu = new StringBuilder();
        sbu.append(this.prefix);
        for (int i = 0; i < this.count; ++i) {
            sbu.append(i > 0 ? this.separator : "");
            int gen = GENERATOR.nextInt(256);
            if (gen < 16) {
                sbu.append("0");
            }
            sbu.append(Integer.toHexString(gen));
        }
        this.lastValue = new OctetString(sbu.toString());
    }

    @Override
    public void setValue(Variable v) {
        this.lastValue = new OctetString(((Object)v).toString());
    }
}

